% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corrPairs.R
\name{corrPairs}
\alias{corrPairs}
\title{corrPairs}
\usage{
corrPairs(
  data,
  method = c("pearson", "kendall", "spearman"),
  interactive = TRUE,
  col_by = NULL
)
}
\arguments{
\item{data}{A data frame containing the variables to be plotted.}

\item{method}{A character string specifying the correlation method. One of
"pearson", "kendall", or "spearman". Default is "pearson".}

\item{interactive}{A logical value indicating whether the output plot should
be interactive (TRUE) or static (FALSE). Default is TRUE.}

\item{col_by}{An optional character string specifying the name of the
column in the data frame to be used for coloring points. Default is NULL.}
}
\value{
A ggplotly object (if interactive = TRUE) or a ggplot object (if
  interactive = FALSE) displaying the pairwise correlation plot with
  annotated correlation coefficients and optional coloring by the specified
  variable.
}
\description{
This function creates a pairwise correlation plot with annotated correlation
coefficients and optional coloring by a specified variable. The plot can be
interactive or static.
}
\examples{
corrPairs(data = mtcars[,1:4],
         method = "pearson",
         interactive = TRUE,
         col_by = "cyl")

}
