% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_df.R
\name{autoplot.cor_df}
\alias{autoplot.cor_df}
\title{Create a correlation matrix from a cor_df object}
\usage{
\method{autoplot}{cor_df}(
  object,
  ...,
  method = "PCA",
  triangular = c("upper", "lower", "full"),
  barheight = 20,
  low = "#B2182B",
  mid = "#F1F1F1",
  high = "#2166AC"
)
}
\arguments{
\item{object}{A \code{cor_df} object.}

\item{...}{this argument is ignored.}

\item{method}{String specifying the arrangement (clustering) method.
Clustering is achieved via \code{\link[seriation]{seriate}}, which can be
consulted for a complete list of clustering methods. Default = "PCA".}

\item{triangular}{Which part of the correlation matrix should be shown?
Must be one of \code{"upper"}, \code{"lower"}, or \code{"full"}, and defaults to \code{"upper"}.}

\item{barheight}{A single, non-negative number. Is passed to
\code{\link[ggplot2:guide_colourbar]{ggplot2::guide_colourbar()}} to determine the height of the guide colorbar.
Defaults to 20, is likely to need manual adjustments.}

\item{low}{A single color. Is passed to \code{\link[ggplot2:scale_gradient]{ggplot2::scale_fill_gradient2()}}.
The color of negative correlation. Defaults to \code{"#B2182B"}.}

\item{mid}{A single color. Is passed to \code{\link[ggplot2:scale_gradient]{ggplot2::scale_fill_gradient2()}}.
The color of no correlation. Defaults to \code{"#F1F1F1"}.}

\item{high}{A single color. Is passed to \code{\link[ggplot2:scale_gradient]{ggplot2::scale_fill_gradient2()}}.
The color of the positive correlation. Defaults to \code{"#2166AC"}.}
}
\value{
A ggplot object
}
\description{
This method provides a good first visualization of the correlation matrix.
}
\examples{
x <- correlate(mtcars)

autoplot(x)

autoplot(x, triangular = "lower")

autoplot(x, triangular = "full")
}
