% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{textrepel}
\alias{textrepel}
\title{textrepel - Plot text with non-overlapping labels}
\usage{
textrepel(
  x,
  y,
  labels = NULL,
  padding = " ",
  rstep = 0.1,
  tstep = 0.1,
  vertical = FALSE,
  textSize = 1,
  showLines = TRUE,
  lineColor = "#00000066",
  lineWidth = 2,
  showPoints = TRUE,
  pointColor = "#00000033",
  pointSize = 2,
  pointPch = 16,
  add = FALSE,
  ...
)
}
\arguments{
\item{x}{A numeric vector of x coordinates}

\item{y}{A numeric vector of y coordinates (must have the same length of x)}

\item{labels}{A vector of labels associated with x and y (must have the same length of x)}

\item{padding}{A character object specifying left and right padding for words. Default is a
single whitespace " "}

\item{rstep}{Decimal numeric specifying the lateral step length for label distancing.
Default is 0.1}

\item{tstep}{Decimal numeric specifying the theta step length for label distancing.
Default is 0.1}

\item{vertical}{Boolean. If FALSE (default), the labels are plotted horizontally. If TRUE,
vertically}

\item{textSize}{Numeric. Size of text. Default is 1}

\item{showLines}{Boolean. Whether to show lines connecting displaced labels to their original
plot. Default is TRUE}

\item{lineColor}{String indicating the color of the connecting line}

\item{lineWidth}{Numeric indicating the width of the connecting line}

\item{showPoints}{Boolean. Whether to show points over original x-y coordinates}

\item{pointColor}{String indicating the color of the point}

\item{pointSize}{Numeric indicating the size of the point}

\item{pointPch}{Integer applying to shape of points. Default is 16 (filled circle)}

\item{add}{Boolean. If FALSE (default), a new plot is generated. If TRUE, the textrepel labels
are plotted over the existing plot}

\item{...}{Arguments to be passed to the core _plot_ function}
}
\value{
A plot
}
\description{
This function plots text with x and y coordinates, forcing overlapping labels to not overlap
}
\examples{
# Simple example, generating a new plot, taking care of some overlapping labels
set.seed(1)
x<-rnorm(100)
y<-abs(x)+rnorm(100)
names(x)<-names(y)<-paste0("OBJ",1:length(x))
labels<-names(x)
textrepel(x,y,labels)
# More advanced example, adding textrepel over an existing plot
set.seed(1)
x<-rnorm(1000)
y<-abs(x)+rnorm(1000)
names(x)<-names(y)<-paste0("GENE",1:length(x))
labels<-names(x)
plot(x,y,pch=16,col="#00000066",xlim=1.3*c(min(x),max(x)))
subset1<-which(x<(-2.2))
textrepel(x[subset1],y[subset1],labels[subset1],add=TRUE,pointCol="cornflowerblue")
subset2<-which(x>(+2.2))
textrepel(x[subset2],y[subset2],labels[subset2],add=TRUE,pointCol="salmon")
}
