% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_datos_abiertos_aux.R
\encoding{UTF-8}
\name{read_datos_abiertos_zip}
\alias{read_datos_abiertos_zip}
\alias{read_datos_abiertos_csv}
\alias{read_datos_abiertos_duckdb}
\title{Auxiliares de lectura para la base de la Direccion General de Epidemiologia}
\usage{
read_datos_abiertos_zip(
  datos_abiertos_zip_paths,
  diccionario_zip_path = NULL,
  diccionario_unzipped_path = NULL,
  diccionario = NULL,
  read_format = c("duckdb", "tibble"),
  tblname = "covidmx",
  drv = duckdb::duckdb(),
  dbdir = tempfile(fileext = ".duckdb"),
  colClasses = get_col_class(),
  download_process = c("pins", "download.file"),
  site.covid.dic = paste0("http://datosabiertos.salud.", "gob.mx/gobmx/salud/datos_a",
    "biertos/diccionario_datos_", "covid19.zip"),
  unzip_command = Sys.getenv("unzip_command"),
  unzip_args = Sys.getenv("unzip_args"),
  unzip_args_dict = list(exdir = ".", overwrite = TRUE),
  check_unzip_install = TRUE,
  clear_zip = (download_process[1] != "pins"),
  clear_csv = TRUE,
  use_dict = TRUE,
  quiet = FALSE,
  cache_datos = NULL,
  use_cache_on_failure = TRUE,
  cache_diccionario = NULL,
  force_download = FALSE,
  show_warnings = TRUE,
  board_url_name = "datos_abiertos",
  board_url_name_dict = "diccionario_covid",
  download_file_args = list(method = "curl", destfile = tempfile(), quiet = quiet),
  descarga_db_diccionario_ssa_args = list(),
  ...
)

read_datos_abiertos_csv(
  datos_abiertos_unzipped_path,
  diccionario_zip_path = NULL,
  diccionario_unzipped_path = NULL,
  diccionario = NULL,
  read_format = c("duckdb", "tibble"),
  tblname = "covidmx",
  drv = duckdb::duckdb(),
  dbdir = tempfile(fileext = ".duckdb"),
  colClasses = get_col_class(),
  download_process = c("pins", "download.file"),
  site.covid.dic = paste0("http://datosabiertos.salud.", "gob.mx/gobmx/salud/datos_a",
    "biertos/diccionario_datos_", "covid19.zip"),
  unzip_args_dict = list(exdir = ".", overwrite = TRUE),
  clear_csv = TRUE,
  quiet = FALSE,
  use_cache_on_failure = TRUE,
  cache_diccionario = NULL,
  force_download = FALSE,
  show_warnings = TRUE,
  board_url_name_dict = "diccionario_covid",
  download_file_args = list(method = "curl", destfile = tempfile(), quiet = quiet),
  descarga_db_diccionario_ssa_args = list(),
  ...
)

read_datos_abiertos_duckdb(
  datos_abiertos_tbl,
  drv = duckdb::duckdb(),
  tblname = "covidmx",
  pragma_memory_limit = Sys.getenv("pragma_memory_limit"),
  diccionario_zip_path = NULL,
  diccionario_unzipped_path = NULL,
  diccionario = NULL,
  download_process = c("pins", "download.file"),
  site.covid.dic = paste0("http://datosabiertos.salud.", "gob.mx/gobmx/salud/datos_a",
    "biertos/diccionario_datos_", "covid19.zip"),
  unzip_args_dict = list(exdir = ".", overwrite = TRUE),
  clear_zip = download_process[1] != "pins",
  clear_csv = TRUE,
  use_dict = TRUE,
  quiet = FALSE,
  use_cache_on_failure = TRUE,
  cache_diccionario = NULL,
  force_download = FALSE,
  show_warnings = TRUE,
  board_url_name_dict = "diccionario_covid",
  download_file_args = list(method = "curl", destfile = tempfile(), quiet = quiet),
  descarga_db_diccionario_ssa_args = list(),
  ...
)
}
\arguments{
\item{datos_abiertos_zip_paths}{(\strong{opcional})  Camino a los datos abiertos si ya los
descargaste en \code{zip}}

\item{diccionario_zip_path}{(\strong{opcional})  Camino al diccionario si ya losdescargaste en \code{zip}}

\item{diccionario_unzipped_path}{(\strong{opcional})  Camino al diccionario \code{csv} si ya
lo descargaste y descomprimiste el archivo \code{zip} en un \code{csv}}

\item{diccionario}{(\strong{opcional})  Lo que resulta de realizar una descarga del diccionario
usando \code{descarga_diccionario}}

\item{read_format}{(\strong{opcional}) \code{"duckdb"} o \code{"tibble"} establece el formato
de lectura de la base de datos. En la mayoria de los casos \code{"tibble"} va a
resultar en un error de memoria. La opcion de \code{"duckdb"} siempre es mas rapida por lo cual
es el default.}

\item{tblname}{(\strong{opcional})  Nombre de la tabla de \code{duckdb} donde guardar los datos por
default se llama \code{covidmx}. Solo es relevante si estas usando el mismo \code{dbdir} para otro
proyecto distinto.}

\item{drv}{(\strong{opcional}) Un  driver para \code{dbConnect} (default \code{duckdb::duckdb()})}

\item{dbdir}{(\strong{opcional}) Direccion donde guardar la base de datos con terminacion \code{.duckdb}.
Corresponde al argumento de \code{\link[duckdb:duckdb]{duckdb::dbConnect__duckdb_driver()}}}

\item{colClasses}{(\strong{opcional}) Clases de la columna para leer en \code{duckdb::read_csv_duckdb()}.}

\item{download_process}{(\strong{opcional})  Metodo para descargar ya sea \code{pins} o \code{download.file}.
Se recomienda \code{pins} pues guarda en memoria la fecha de la ultima descarga y analiza
si ha pasado mas de un dia desde la descarga. En caso afirmativo verifica si el
archivo ha cambiado y si hubo cambios entonces lo descarga.}

\item{site.covid.dic}{(\strong{opcional})  Sitio desde el cual descarga del diccionario de datos.
La ultima verificacion del sitio fue el 6 de septiembre 2022.}

\item{unzip_command}{(\strong{opcional}) Forma de extraer la base de datos de datos abiertos
si \code{unzip} falla.
La forma de llamarla es con \code{system2(unzip_command, args = c(unzip_args, file_download_data))}.}

\item{unzip_args}{(\strong{opcional}) Argumentos de extraccion de la base de datos de datos abiertos
si \code{unzip} falla.
La forma de llamarla es con \code{system2(unzip_command, args = c(unzip_args, file_download_data))}.}

\item{unzip_args_dict}{(\strong{opcional}) Lista de argumentos para usar \code{utils::unzip} en el
diccionario de datos.}

\item{check_unzip_install}{(\strong{opcional}) Bandera de verificacion para checar si tienes
lo necesario para unzippear los datos en el caso de que \code{unzip} no sirva.}

\item{clear_zip}{(\strong{opcional}) Si borrar los archivos \code{.zip} descargados para el diccionario
y los datos abiertos. No se recomienda si estas usando \code{pins}. Ve la nota para mas informacion.}

\item{clear_csv}{(\strong{opcional}) Si borrar los archivos \code{.csv} que se generan despues de abrir
el zip. El default es que si pues en general solo requieres el \code{duckdb}.}

\item{use_dict}{(\strong{opcional}) Si descargar el diccionario de \code{site.covid.dic}.}

\item{quiet}{(\strong{opcional}) Variable para no mostrar mensajes}

\item{cache_datos}{(\strong{opcional}) Direccion donde guardar los datos en memoria usando \code{pins}
para no tener que volver a descargarlos si nada ha cambiado}

\item{use_cache_on_failure}{(\strong{opcional}) Booleana. Establece que si no se pueden descargar
datos nuevos utilice los que tenga en memoria. Por default es \code{TRUE}.}

\item{cache_diccionario}{(\strong{opcional}) Direccion donde guardar el diccionario en memoria
usando \code{pins} para no tener que volver a descargarlo si nada ha cambiado}

\item{force_download}{(\strong{opcional}) Analiza si cambio el pin y descarga datos nuevos en caso
afirmativo aunque haya pasado menos de un dia.}

\item{show_warnings}{(\strong{opcional}) si arrojar \code{warnings}}

\item{board_url_name}{(\strong{opcional}) Establece el nombre del \code{pins::board_url} para
los datos abiertos (si ya usas pins para que no se empalme).
Por default se llama \code{datos_abiertos}}

\item{board_url_name_dict}{(\strong{opcional}) Establece el nombre del \code{pins::board_url} para los
datos abiertos. Por default se llama \code{diccionario_covid}}

\item{download_file_args}{(\strong{opcional}) Lista de argumentos adicionales para \code{download.file}
de los datos si se elige este metodo para descargar.}

\item{descarga_db_diccionario_ssa_args}{(\strong{opcional}) Lista con argumentos adicionales para el
\code{pins::pin_download} de datos abiertos}

\item{...}{(\strong{opcional}) Parametros adicionales para \code{DBI::dbConnect}.}

\item{datos_abiertos_unzipped_path}{(\strong{opcional})  Camino a los datos abiertos \code{csv} si ya
los descargaste y descomprimiste el archivo \code{zip} en un \code{csv}}

\item{datos_abiertos_tbl}{(\strong{opcional}) Camino a un archivo \code{.duckdb} con los datos formateados}

\item{pragma_memory_limit}{(\strong{opcional}) Limite de memoria para el programa
(ver \href{https://duckdb.org/docs/sql/pragmas}{PRAGMAS}). Cambialo a que sea mas o menos la mitad
de tu RAM. La forma mas sencilla es como una variable ambiental con
\code{Sys.setenv('pragma_memory_limit' = '1GB')} por ejemplo para un limite de 1 gigabyte.}
}
\value{
Lista de valores:
\itemize{
\item dats        - Tabla conectada mediante \code{DBI::dbConnect} (si \code{duckdb}) o
tibble (si \code{tibble})
\item disconnect  - Funcion para cerrar la conexion a la base de datos.
\item dict        - Lista de \code{tibble}s con el diccionario de datos para cada variable
}
}
\description{
La funcion principal es \code{\link[=read_datos_abiertos]{read_datos_abiertos()}} la cual decide si los lee de \code{zip},
\code{duckdb} o \code{csv} Tambien puedes usar las auxiliares respectivas
\itemize{
\item \code{\link[=read_datos_abiertos_zip]{read_datos_abiertos_zip()}}     Si sólo descargaste los datos de la DGE en \code{.zip}
\item \code{\link[=read_datos_abiertos_csv]{read_datos_abiertos_csv()}}     Si descargaste los datos de la DGE en \code{.zip} y
los descomprimiste.
\item \code{\link[=read_datos_abiertos_duckdb]{read_datos_abiertos_duckdb()}}  Si ya creaste tu table en \code{duckdb}
}
}
\note{
Para guardar tu base con \code{duckdb} cambia el \code{dbdir} a un archivo \code{.duckdb}. Como ejemplo
\code{dbdir = "ejemplo.duckdb"}.
}
\examples{
\donttest{
# Lee los datos de duckdb una vez descargados
# quita la opción de sites.covid para descargar los de la DGE. 
# Esto es solo un ejemplo.
file_ejemplo <- tempfile(fileext = ".duckdb")

#Estos links deben omitirse en una corrida normal. Se incluyen por ahora como ejemplo
#pero las opciones site.covid.dic y sites.covid deben eliminarse de abajo.
dlink        <- "https://github.com/RodrigoZepeda/covidmx/raw/main/datos_abiertos_covid19.zip"
diclink      <- "https://github.com/RodrigoZepeda/covidmx/raw/main/diccionario_datos_covid19.zip"

#En el ejemplo de R por normas de CRAN tenemos que hacerlo así pero en tu
#computadora puedes solo usar descargar datos sin el if else
if (RCurl::url.exists(dlink) & RCurl::url.exists(diclink)){

  #Necesitamos la base para verificar los reads
  datos_covid <- descarga_datos_abiertos(
    dbdir = file_ejemplo,
    sites.covid = dlink, 
    site.covid.dic = diclink,
    show_warnings = FALSE
  )
  datos_covid$disconnect()
  
  datos_covid <- read_datos_abiertos(file_ejemplo, show_warnings = FALSE, 
                    site.covid.dic = diclink)
  datos_covid$disconnect()

   # Es lo mismo que:
  datos_covid <- read_datos_abiertos_duckdb(file_ejemplo, show_warnings = FALSE,
                                            site.covid.dic = diclink)
  datos_covid$disconnect()

  # Descarga los datos y lee de un zip guardandolos a la vez en
  # base de nombre datos_desde_zip.duckdb
  direccion_zip <- descarga_db_datos_abiertos_tbl(sites.covid = dlink, show_warnings = FALSE,
                                                  site.covid.dic = diclink)
                                                 
  datos_covid <- read_datos_abiertos(direccion_zip,
    dbdir = file_ejemplo,
    site.covid.dic = diclink,
    show_warnings = FALSE
  )
  datos_covid$disconnect()

  # Es lo mismo que:
  datos_covid <- read_datos_abiertos_zip(direccion_zip,
    site.covid.dic = diclink,
    dbdir = file_ejemplo,
    show_warnings = FALSE
  )
  datos_covid$disconnect()

  # Descarga los datos y lee de un csv
  direccion_zip <- descarga_db_datos_abiertos_tbl(sites.covid = dlink, show_warnings = FALSE)
  direccion_csv <- unzip_db_datos_abiertos_tbl(direccion_zip)
  datos_covid   <- read_datos_abiertos(direccion_csv, show_warnings = FALSE, 
                                          site.covid.dic = diclink)
  datos_covid$disconnect()

  # Es lo mismo que:
  direccion_csv <- unzip_db_datos_abiertos_tbl(direccion_zip)
  datos_covid   <- read_datos_abiertos_csv(direccion_csv, show_warnings = FALSE,
                          site.covid.dic = diclink)
  datos_covid$disconnect()
}
}
}
