% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refactor.R
\name{cps_recode_vote}
\alias{cps_recode_vote}
\title{recode the voting variable for turnout calculations}
\usage{
cps_recode_vote(
  data,
  vote_col = "VRS_VOTE",
  items = c("DON'T KNOW", "REFUSED", "NO RESPONSE")
)
}
\arguments{
\item{data}{the input data set}

\item{vote_col}{which column contains the voting variable}

\item{items}{which items should be "No" in the CPS coding and \code{NA} in the
Hur & Achen coding}
}
\value{
\code{data} with two columns attached, \code{cps_turnout} and \code{hurachen_turnout},
voting variables recoded according to the process above
}
\description{
When the CPS calculates voter turnout, they consider the values "Don't know",
"Refused", and "No response" to be non-voters, that is they lump these in
with "No". With increased levels of survey non-response in recent years, this
has caused turnout estimates to artificially deflate when compared to
measures of voter turnout from state election offices. This function adds two
recodes of the original voting variable, one which applies the CPS recoding
where multiple categories map to "No", and one which follows the guidelines
from Hur & Achen (2013) of setting these categories to \code{NA}. See the Vignette
for more information on this process.
}
\examples{
cps_recode_vote(cps_refactor(cps_label(cps_2016_10k)))

}
