% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{Boston_df}
\alias{Boston_df}
\title{Boston Housing Data}
\format{
A data frame with 506 observations and 14 variables:
\describe{
  \item{crim}{Per capita crime rate by town (numeric).}
  \item{zn}{Proportion of residential land zoned for lots over 25,000 sq.ft. (numeric).}
  \item{indus}{Proportion of non-retail business acres per town (numeric).}
  \item{chas}{Charles River dummy variable (= 1 if tract bounds river; 0 otherwise) (integer).}
  \item{nox}{Nitrogen oxides concentration (parts per 10 million) (numeric).}
  \item{rm}{Average number of rooms per dwelling (numeric).}
  \item{age}{Proportion of owner-occupied units built prior to 1940 (numeric).}
  \item{dis}{Weighted mean of distances to five Boston employment centres (numeric).}
  \item{rad}{Index of accessibility to radial highways (integer).}
  \item{tax}{Full-value property-tax rate per $10,000 (numeric).}
  \item{ptratio}{Pupil-teacher ratio by town (numeric).}
  \item{black}{1000(Bk - 0.63)^2 where Bk is the proportion of Black population by town (numeric).}
  \item{lstat}{Lower status of the population (percent) (numeric).}
  \item{medv}{Median value of owner-occupied homes in $1000s (numeric).}
}
}
\source{
This dataset was obtained from the Boston dataset, which is part of the MASS package, with slight modifications.
}
\usage{
data(Boston_df)
}
\description{
This dataset contains information on housing values and various factors influencing those values
in 506 suburbs of Boston. It provides detailed insights into the factors such as crime rates,
proximity to highways, and the quality of the local environment that may affect housing prices.
}
\details{
The dataset name has been changed to 'Boston_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
crimedatasets package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a traditional data frame in R. The original content has not been modified in any way.
}
