% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clpm_poly_c.R
\name{clpm_poly_c}
\alias{clpm_poly_c}
\title{Title Nonlinear Cross Lag Analysis based on Polynomial linear regression}
\usage{
clpm_poly_c(xname, yname, data1, data2, adjust = FALSE, adjust_name = NULL)
}
\arguments{
\item{xname}{If cross lagged analysis is used between x and y, 'xname' is the name of x}

\item{yname}{If cross lagged analysis is used between x and y, 'xname' is the name of x}

\item{data1}{A dataframe containing data of x and y at the same time point.
If covariate adjustments are made (adjust=T), data of covariates should also be included.
The input 'xname','yname' and 'adjust_name' is written in the same way among the 'data1' column names}

\item{data2}{A dataframe containing data of x and y at the another time point.
If covariate adjustments are made (adjust=T), data of covariates should also be included.
The input 'xname','yname' and 'adjust_name' is written in the same way among the 'data2' column names}

\item{adjust}{The default value is F.
If you want to perform covariate adjustments on x and y based on adjust_target(), please use T.}

\item{adjust_name}{The name of the covariate, corresponding to the data contained in data1 or data2.
If there are multiple covariates, they need to be saved in a vector.}
}
\value{
A dataframe containing the result of Nonlinear Cross Lag Analysis after polynomial regression
}
\description{
Title Nonlinear Cross Lag Analysis based on Polynomial linear regression
}
\examples{
data(test_data1)
data(test_data2)
# Not adjusting for covariates
result <- clpm_poly_c(xname = "PWRI",yname = "LDL_C",
                      data1 = test_data1,data2 = test_data2,adjust = FALSE)
# Adjust for covariates
result_ad <- clpm_poly_c(xname = "ASI",yname = "PWRI",
                         data1 = test_data1,data2 = test_data2,
                         adjust = TRUE,adjust_name=c("HDL_C","LDL_C"))
}
