% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coinbase.R
\name{coinbase_candles}
\alias{coinbase_candles}
\title{coinbase_candles}
\usage{
coinbase_candles(
  api_key,
  api_secret,
  product_id,
  start,
  end,
  granularity,
  timeout_seconds = 60
)
}
\arguments{
\item{api_key}{your Coinbase API key}

\item{api_secret}{your Coinbase API secret}

\item{product_id}{the trading pair.}

\item{start}{timestamp for starting range of aggregations, in UNIX time.}

\item{end}{timestamp for ending range of aggregations, in UNIX time.}

\item{granularity}{time slice value for each candle. Options: "ONE_MINUTE",
"FIVE_MINUTE", "FIFTEEN_MINUTE", "THIRTY_MINUTE", "ONE_HOUR", "TWO_HOUR",
"SIX_HOUR", or "ONE_DAY"}

\item{timeout_seconds}{seconds until the query times out. Default is 60.}
}
\value{
returns a dataframe with your Coinbase candle data.
}
\description{
coinbase_candles
}
\examples{
\dontrun{
api_key <- "..."
api_secret <- "..."
end <- coinbase_time()
end_timestamp <- as.POSIXct(end, origin = "1970-01-01", tz = "UTC")
start_timestamp <- end_timestamp - 20 * 60  # 20 minutes in seconds
start <- as.numeric(start_timestamp)
coinbase_candles(api_key, api_secret, 'BTC-USD', start, end, 'ONE_MINUTE')}
}
