% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{write.ctf}
\alias{write.ctf}
\title{Write Data Frame To CTF}
\usage{
write.ctf(x, datadir = name, name = deparse(substitute(x)), ...)
}
\arguments{
\item{x}{data frame to write}

\item{datadir}{directory to write the metadata and CTF columns}

\item{name}{table name}

\item{...}{further arguments to \code{\link[iotools]{write.table.raw}}}
}
\value{
\code{NULL}, used for its side effect
}
\description{
Save a data frame using Column Text Format
}
\examples{
d <- file.path(tempdir(), "iris_ctf_data")
write.ctf(iris, d)

# Same object as iris, but carries around some extra metadata
iris2 <- read.ctf(d)

# This directory contains plain text files for each column in iris
list.files(d)

# Clean up
unlink(d, recursive = TRUE)
}
\seealso{
\code{\link{read.ctf}} to read CTF, \code{\link[iotools]{write.table.raw}} for the underlying functionality, and \code{\link[base]{save}} for writing any R objects.
}
