% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioactivity-APIs.R
\name{get_bioactivity_details}
\alias{get_bioactivity_details}
\title{Retrieve bioactivity data from DTXSID, AEID, SPID, or m4id}
\usage{
get_bioactivity_details(
  DTXSID = NULL,
  AEID = NULL,
  SPID = NULL,
  m4id = NULL,
  API_key = NULL,
  Server = bioactivity_api_server,
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{The chemical identifier DTXSID}

\item{AEID}{The assay endpoint identifier AEID}

\item{SPID}{The ChemSpider chemical input}

\item{m4id}{The chemical identifier m4id}

\item{API_key}{The user-specific API key}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A data.frame containing bioactivity information for the chemical or assay endpoint with
identifier matching the input parameter.
}
\description{
Retrieve bioactivity data from DTXSID, AEID, SPID, or m4id
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) withAutoprint(\{ # examplesIf}
# Pull BPA bioactivity details
bpa <- get_bioactivity_details(DTXSID = 'DTXSID7020182')
# Pull assay bioactivity details
assay <- get_bioactivity_details(AEID = 159)
\dontshow{\}) # examplesIf}
}
