% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D1Bsplines.R
\name{D1Bsplines}
\alias{D1Bsplines}
\title{Computation of the 1st derivative of a cubic B-spline basis associated to a given vector of knots}
\usage{
D1Bsplines(x, knots)
}
\arguments{
\item{x}{vector of values where the 1st derivative of the B-spline basis must be evaluated.}

\item{knots}{vector of knots spanning the desired B-spline basis.}
}
\value{
A matrix of dimension \code{length(x)} by \code{(length(knots)+2)}.

Each column corresponds to (the 1st derivative of) one cubic B-spline in the basis.
}
\description{
Computation of the 1st derivative of a cubic B-spline basis associated to a given vector of knots
}
\examples{
D1Bsplines(x=runif(20),knots=seq(0,1,length=11))
}
