% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curry.R
\name{curry}
\alias{\%<\%}
\alias{curry}
\title{Curry a function from the start}
\usage{
fun \%<\% arg

curry(fun, arg)
}
\arguments{
\item{fun}{A function to be curried. Can be any function (normal,
already curried, primitives).}

\item{arg}{The value that should be applied to the first argument.}
}
\value{
A function with the same arguments as \code{fun} except for the
first, unless the first is \code{...} in which case it will be retained.
}
\description{
The \code{curry} function and the \code{\%<\%} operator performs currying on
a function by partially applying the first argument, returning a function
that accepts all but the first arguments of the former function. If the first
argument is \code{...} the curried argument will be interpreted as part of
the ellipsis and the ellipsis will be retained in the returned function. It
is thus possible to curry functions comtaining ellipis arguments to infinity
(though not adviced).
}
\note{
Multiple currying does not result in multiple nested calls, so while
the first currying adds a layer around the curried function, potentially
adding a very small performance hit, currying multiple times will not add to
this effect.
}
\examples{
# Equivalent to curry(`+`, 5)
add_5 <- `+` \%<\% 5
add_5(10)

# ellipsis are retained when currying
bind_5 <- cbind \%<\% 5
bind_5(1:10)

}
\seealso{
Other partials: \code{\link{partial}},
  \code{\link{tail_curry}}
}

