% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-guts.R
\name{GUTS_IT}
\alias{GUTS_IT}
\alias{GutsIt-class}
\alias{GUTS-IT}
\title{GUTS-IT scenario}
\usage{
GUTS_IT(scaled_ci = FALSE, dose_metric = c("D", "Ci", "Cw"))
}
\arguments{
\item{scaled_ci}{\code{logical}, switch to enable scaling. If \code{TRUE}, the model
will use the scaled internal concentration \verb{Ci*}. Else no scaling. Default
value is \code{FALSE}.}

\item{dose_metric}{\code{character}, selects the dose metric. \code{'D'} to use damage, \code{'Ci'} to
for internal concentration, or \code{'Cw'} for the external concentration. Default
value is \code{'D'}.}
}
\value{
an S4 object of type \code{GutsIt-class}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}\if{html}{\out{<br/>}}
Full \emph{General Unified Threshold models of Survival} (GUTS) with Individual Tolerance
compatible with the \emph{Full GUTS} model as described by EFSA (2018), but
some parameter names may differ.
}
\section{State variables}{

The following list describes the default names and standard units of \emph{GUTS}
state variables:
\itemize{
\item \code{Ci}, (scaled) internal concentration (conc)
\item \code{D}, (scaled) damage (*)
\item \code{H}, cumulative hazard (-)
}

The state variables are initialized with zero by default.
}

\section{IT model parameters}{

The set of parameters and their names follows the definition by Jager et al
(2011). The actual number of required parameters depends on the selected model
variant, i.e. if the internal concentration is scaled or not, as well as the
selected dose metric. The full set of parameters is as follows
\itemize{
\item \code{ki}, accumulation rate into body (time^-1)
\item \code{ke}, elimination rate (time^-1)
\item \code{Kiw}, scaling constant for external concentration (*)
\item \code{kr}, damage recovery rate (time^-1)
\item \code{hb}, background hazard rate (time^-1)
\item \code{alpha}, median of thresholds (conc)
\item \code{beta}, shape parameter (-)
}
}

\section{Effects}{

The effect endpoint \code{L} (lethality) is available for \emph{GUTS} models.
A value of zero (\code{0.0}) denotes \emph{no effect} on organism survival. A value of
one (\code{1.0}) denotes a lethality rate of 100\%, i.e. no survivors.

The survival probability \code{S} is available in the return value of \code{\link[=simulate]{simulate()}}.
}

\references{
EFSA PPR Panel (EFSA Panel on Plant Protection Products and their Residues),
Ockleford C, Adriaanse P, Berny P, et al., 2018: \emph{Scientific Opinion on the
state of the art of Toxicokinetic/Toxicodynamic (TKTD) effect models for
regulatory risk assessment of pesticides for aquatic organisms}. EFSA Journal 2018;
16(8):5377, 188 pp. \doi{10.2903/j.efsa.2018.5377}

Jager T., Albert C., Preuss T.G., and Ashauer R., 2011: General Unified Threshold
Model of Survival - a Toxicokinetic-Toxicodynamic Framework for Ecotoxicology.
Environ. Sci. Technol. 45(7), pp. 2529-2540. \doi{10.1021/es103092a}
}
\seealso{
\link{GUTS-RED-IT}

Other GUTS models: 
\code{\link{GUTS_SD}()}
}
\concept{GUTS models}
