% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distrFit.R
\name{distrFit}
\alias{distrFit}
\title{distrFit}
\usage{
distrFit(breaks, counts, distr, initials)
}
\arguments{
\item{breaks}{Vector defining the breaks in each group}

\item{counts}{Vector containing the frequency of counts in each group}

\item{distr}{Character; the name of the distribution users want to fit the data to

distrFit supports all of the continuous distributions supported in \code{\link{groupFit}}:}

\item{initials}{Vector of initial values for the maximum likelihood estimates.}
}
\value{
distFit returns a vector containing the MLEs.
}
\description{
Finds the Maximum Likelihood Estimates of the parameters in a requested distribution.
}
\details{
distFit uses Maximum Likelihood Estimates to optimize the parameters for a requested distribution.
}
\examples{

#fitting exponential data without initial values (Spinelli 2001)

breaks <- c(0, 2, 6, 10, 14, 18, 22, 26)
counts <- c(21, 9, 5, 2, 1, 1, 0)

(mle1 <- distrFit(breaks, counts, distr = "exp"))

#fitting generated data with initial values

breaks <- seq(0, 40, 2)
counts <- table(cut(rweibull(200, 0.5, 3), breaks))

(mle2 <- distrFit(breaks, counts, distr = "weibull", initials = c(0.5, 3)))

#fitting generated data to a different distribution

breaks <- seq(-100, 100, 5)
counts <- table(cut(rcauchy(500, -20, 10), breaks))

(mle3 <- distrFit(breaks, counts, distr = "norm"))

}
\seealso{
\code{\link{groupFit}} for fitting data and providing GoF statistics.
}
\author{
Shaun Zheng Sun and Dillon Duncan
}
