% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_param.R
\name{build_param}
\alias{build_param}
\title{Build param structure}
\usage{
build_param(sp, sites, rates, env, num.params = NULL)
}
\arguments{
\item{sp}{character vector with species names}

\item{sites}{character vector with site names}

\item{rates}{character vector, vital rate names}

\item{env}{boolean, whether environment is accounted for}

\item{num.params}{optional, integer giving the number of parameters to account for.
If not specified, it will include environment interactions with all species densities.
E.g. if 3 sp and env = TRUE, there will be 7 params (intercept + 6 betas)}
}
\value{
nested list of the form `list[[sp]][[site]]`. Each of these elements
is a NA matrix with vital rates in rows and expected parameters in columns.
}
\description{
Builds a nested list for the parameters of a given metapopulation
}
\examples{
sp <- c("s1","s2","s3")
sites <- c("sa","sb")
rates <- c("Sj","Sn","Sr","Rn","Rr","D","O")
env <- TRUE
param <- build_param(sp = sp,sites = sites,rates = rates,env = env)
}
