% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cyl_cop_class.R, R/cyl_cubsec.R,
%   R/cyl_quadsec.R, R/cyl_rect_combine.R, R/cyl_rot_combine.R, R/cyl_vonmises.R
\name{Cylcop}
\alias{Cylcop}
\alias{rcylcop}
\alias{pcylcop}
\alias{dcylcop}
\alias{dcylcop,matrix,Copula-method}
\alias{rcylcop,numeric,Copula-method}
\alias{pcylcop,matrix,Copula-method}
\alias{rcylcop,numeric,cyl_cubsec-method}
\alias{dcylcop,matrix,cyl_cubsec-method}
\alias{pcylcop,matrix,cyl_cubsec-method}
\alias{rcylcop,numeric,cyl_quadsec-method}
\alias{dcylcop,matrix,cyl_quadsec-method}
\alias{pcylcop,matrix,cyl_quadsec-method}
\alias{rcylcop,numeric,cyl_rect_combine-method}
\alias{dcylcop,matrix,cyl_rect_combine-method}
\alias{pcylcop,matrix,cyl_rect_combine-method}
\alias{rcylcop,numeric,cyl_rot_combine-method}
\alias{dcylcop,matrix,cyl_rot_combine-method}
\alias{pcylcop,matrix,cyl_rot_combine-method}
\alias{rcylcop,numeric,cyl_vonmises-method}
\alias{dcylcop,matrix,cyl_vonmises-method}
\alias{pcylcop,matrix,cyl_vonmises-method}
\title{Distribution, Density, and Random Number Generation for Circular-Linear Copulas'}
\usage{
pcylcop(u, copula)

rcylcop(n, copula)

dcylcop(u, copula, log = FALSE)

\S4method{dcylcop}{matrix,Copula}(u, copula)

\S4method{rcylcop}{numeric,Copula}(n, copula)

\S4method{pcylcop}{matrix,Copula}(u, copula)

\S4method{rcylcop}{numeric,cyl_cubsec}(n, copula)

\S4method{dcylcop}{matrix,cyl_cubsec}(u, copula)

\S4method{pcylcop}{matrix,cyl_cubsec}(u, copula)

\S4method{rcylcop}{numeric,cyl_quadsec}(n, copula)

\S4method{dcylcop}{matrix,cyl_quadsec}(u, copula)

\S4method{pcylcop}{matrix,cyl_quadsec}(u, copula)

\S4method{rcylcop}{numeric,cyl_rect_combine}(n, copula)

\S4method{dcylcop}{matrix,cyl_rect_combine}(u, copula)

\S4method{pcylcop}{matrix,cyl_rect_combine}(u, copula)

\S4method{rcylcop}{numeric,cyl_rot_combine}(n, copula)

\S4method{dcylcop}{matrix,cyl_rot_combine}(u, copula)

\S4method{pcylcop}{matrix,cyl_rot_combine}(u, copula)

\S4method{rcylcop}{numeric,cyl_vonmises}(n, copula)

\S4method{dcylcop}{matrix,cyl_vonmises}(u, copula)

\S4method{pcylcop}{matrix,cyl_vonmises}(u, copula)
}
\arguments{
\item{u}{\link[base]{matrix} (or \link[base]{vector})  of \link[base]{numeric}
values in \eqn{[0,1]^2}, containing as first column the circular (periodic) and
as second the linear dimension}

\item{copula}{\R object of class '\code{\linkS4class{cyl_copula}}'.
or '\code{\link[copula:Copula-class]{Copula}}' (package '\pkg{copula}', only 2-dimensional).}

\item{n}{number of random samples to be generated with \code{rcylcop()}.}

\item{log}{\link[base]{logical} indicating if the logarithm of the density
should be returned (\code{dcylcop()}).}
}
\value{
The functions \code{pcylcop()} and \code{dcylcop()} give a \link[base]{vector} of
length \code{nrow(u)} containing the distribution and the density, respectively,
 at the corresponding values of \code{u}. The function \code{rcylcop()} generates a
 \link[base]{matrix} with 2 columns and \code{n} rows containing
the random samples.
}
\description{
Calculate the distribution (\code{pcylcop()}), the density (\code{dcylcop()}),
and generate random
samples (\code{rcylcop()}) of a '\code{\linkS4class{cyl_copula}}' object or a
'\code{\link[copula:Copula-class]{Copula}}' object (package '\pkg{copula}', only 2-dimensional).
}
\details{
For '\code{\link[copula:Copula-class]{Copula}}' objects, \code{pcylcop()} and \code{rcylcop()}
just call the functions of the '\pkg{copula}' package
\code{\link[copula]{pCopula}()} and \code{\link[copula]{rCopula}()}, respectively.
The density is, however, calculated differently in \code{dcylcop()} and
\code{\link[copula]{dCopula}()}. The difference is
 that \code{copula::\link[copula]{dCopula}()}
 will return a density of 0 for points on the boundary of the unit square,
 whereas \code{dcylcop()} will return the correct density on the boundaries
 for both '\code{\linkS4class{cyl_copula}}' and '\code{\link[copula:Copula-class]{Copula}}' objects.
}
\examples{
set.seed(123)

cop <- cyl_quadsec(0.1)
rcylcop(5, cop)
pcylcop(c(0.3, 0.1), cop)
pcylcop(rbind(c(0.3, 0.1), c(0.2, 1)), cop)

cop <- cyl_rot_combine(copula::frankCopula(2), shift = TRUE)
dcylcop(u = rbind(c(0.1, 0.4), c(1.0, 0.2)), copula = cop)
dcylcop(c(0.1, 0.3), cyl_quadsec(0.1), log = TRUE)

cop <- copula::normalCopula(0.3)
copula::dCopula(c(.Machine$double.eps,0.2),cop)
copula::dCopula(c(0,0.2),cop)
dcylcop(c(.Machine$double.eps,0.2),cop)
dcylcop(c(0,0.2),cop)

}
\references{
\insertRef{Nelsen2006}{cylcop}

\insertRef{Hodelmethod}{cylcop}
}
\seealso{
\code{copula::\link[copula]{dCopula}()},
\code{copula::\link[copula]{pCopula}()},
\code{copula::\link[copula]{rCopula}()}.
}
