% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_stats.R
\name{calc_quantiles}
\alias{calc_quantiles}
\title{Calculate Quantiles}
\usage{
calc_quantiles(
  pdf_u = NULL,
  pdf_l = NULL,
  t_vec = NULL,
  dt = NULL,
  rts_u = NULL,
  rts_l = NULL,
  one_cond,
  probs = NULL,
  b_coding,
  skip_if_contr_low = NULL
)
}
\arguments{
\item{pdf_u, pdf_l}{density values for the upper and lower boundary}

\item{t_vec}{the time space (required for the pdfs)}

\item{dt}{the step size corresponding to the time space}

\item{rts_u, rts_l}{vectors of RTs for the upper and lower boundary}

\item{one_cond}{character label}

\item{probs}{numeric vector with values between 0 and 1 for the probability
levels}

\item{b_coding}{used for accessing the upper/lower boundary labels,
determines the corresponding columns of the returned data.frame
(e.g., Quant_\code{corr}).}

\item{skip_if_contr_low}{numeric. If the contribution of the upper
or lower PDF to the overall PDF is too low, return NAs for
this PDF (see also \code{\link[=drift_dm_skip_if_contr_low]{drift_dm_skip_if_contr_low()}}).}
}
\value{
a data.frame with "Source", "Cond", "Prob"s, "Quant_<u_label>",
"Quant_<l_label>" of type
c("quantiles", "sum_dist", "stats_dm", "data.frame")
}
\description{
Function that calls the underlying quantile calculation functions
\code{\link[=calc_quantiles_obs]{calc_quantiles_obs()}} and \code{\link[=calc_quantiles_pred]{calc_quantiles_pred()}}. Does
input checks and the data wrangling
}
\details{
if pdf_u and pdf_l are not NULL, returns quantiles for the densities

if rts_u and rts_l are not NULL, returns quantiles for the response times

if all are not NULL, returns both.
}
\seealso{
\code{\link[=new_stats_dm]{new_stats_dm()}}
}
\keyword{internal}
