% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_stats.R
\name{stats_resample_dm}
\alias{stats_resample_dm}
\alias{stats_resample_dm.drift_dm}
\alias{stats_resample_dm.data.frame}
\alias{stats_resample_dm.fits_ids_dm}
\title{Resample Observed and Predicted Statistics for Interval Estimation}
\usage{
stats_resample_dm(object, conds, type, b_coding, ..., R, interval_level)

\method{stats_resample_dm}{drift_dm}(
  object,
  conds,
  type,
  b_coding,
  ...,
  R = 100,
  interval_level = 0.95,
  n_sim = NULL
)

\method{stats_resample_dm}{data.frame}(
  object,
  conds,
  type,
  b_coding,
  ...,
  R = 100,
  interval_level = 0.95,
  progress = 0,
  level
)

\method{stats_resample_dm}{fits_ids_dm}(
  object,
  conds,
  type,
  b_coding,
  ...,
  R = 100,
  interval_level = 0.95,
  progress = 0,
  level
)
}
\arguments{
\item{object}{a \code{drift_dm} object (for model-based resampling) or a
\link{data.frame} with observed data for a single participant.
\code{drift_dm_stats_types("sum_dists")}, such as \code{"quantiles"} or \code{"cafs"}.}

\item{conds}{a character vector indicating the condition(s) for which the
statistics should be resampled.}

\item{type}{a character string, specifying the \code{type} of statistic to
calculate}

\item{b_coding}{a list, specifying the boundary coding, required
when calculating the statistics.}

\item{...}{additional arguments passed to
\code{\link[=stats_resample_wrapper]{stats_resample_wrapper()}} and \code{\link[=simulate_data]{simulate_data()}}. Must
contain \code{type} and \code{b_coding}}

\item{R}{an integer, number of replications (default is 100).}

\item{interval_level}{a numeric between 0 and 1, controlling the width of the
interval (default is 0.95).}

\item{n_sim}{an optional vector, providing the trial numbers for simulating
synthetic data under the model. Only relevant when no observed data is
attached to the model via the \code{obs_data} entry of the model.}

\item{progress}{an integer, specifying if a progress bar shall be displayed
(\code{1}) or not (\code{0}).}

\item{level}{a character string, specifying at which level resampling shall
take place. \code{"individual"} will lead to resampling of an individual's data.
\code{"group"} will lead to resampling of the entire participant.}
}
\value{
A \code{stats_dm} object with added column \code{Estimate} indicating whether the row
represents the lower interval bound, the original value (\code{"orig"}), or the
upper interval bound. The interval level can be controlled via the
\code{interval_level} argument.
}
\description{
Internal methods to generate bootstrap-like intervals for
descriptive statistics derived from either observed data or model
predictions. These methods support both \code{drift_dm} objects and
data.frames containing a single participant's observed data.
}
\details{
The \code{stats_resample_dm()} generic dispatches to class-specific methods.
For \code{drift_dm} objects, it generates synthetic data sets under the model.
For raw data, it resamples observations with replacement (i.e, it performs
a bootstrap). In both cases, statistics from the resampled/generated data are
used to compute intervals for the requested statistic.

Resampling is done for each condition separately.

The function \code{stats_resample_dm()} is called within \code{\link[=calc_stats]{calc_stats()}}.
}
\keyword{internal}
