% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clu_cmeans.R
\name{cluster_cmeans}
\alias{cluster_cmeans}
\title{Fuzzy c-means}
\usage{
cluster_cmeans(centers = 2, m = 2, iter = 100, dist = "euclidean")
}
\arguments{
\item{centers}{number of clusters}

\item{m}{fuzziness parameter (m > 1)}

\item{iter}{maximum number of iterations}

\item{dist}{distance method passed to \code{e1071::cmeans}}
}
\value{
returns a fuzzy clustering object.
}
\description{
Fuzzy c-means clustering using \code{e1071::cmeans}.
}
\details{
Produces soft membership for each cluster. The hard assignment is returned by \code{cluster()}.
Membership degrees are returned in the \code{membership} attribute.
}
\examples{
data(iris)
model <- cluster_cmeans(centers = 3, m = 2)
model <- fit(model, iris[,1:4])
clu <- cluster(model, iris[,1:4])
table(clu)
}
\references{
Bezdek, J. C. (1981). Pattern Recognition with Fuzzy Objective Function Algorithms.
}
