% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.plot.faststructure.r
\name{gl.plot.faststructure}
\alias{gl.plot.faststructure}
\title{Plots fastStructure analysis results (Q-matrix)}
\usage{
gl.plot.faststructure(
  sr,
  k.range,
  met_clumpp = "greedyLargeK",
  iter_clumpp = 100,
  clumpak = TRUE,
  plot_theme = NULL,
  colors_clusters = NULL,
  ind_name = TRUE,
  border_ind = 0.15
)
}
\arguments{
\item{sr}{fastStructure run object from \code{\link{gl.run.faststructure}}
[required].}

\item{k.range}{The number for K of the q matrix that should be plotted. Needs 
to be within you simulated range of K's in your sr structure run object. If 
 NULL, all the K's are plotted [default NULL].}

\item{met_clumpp}{The algorithm to use to infer the correct permutations.
One of 'greedy' or 'greedyLargeK' or 'stephens' [default "greedyLargeK"].}

\item{iter_clumpp}{The number of iterations to use if running either 'greedy'
'greedyLargeK' [default 100].}

\item{clumpak}{Whether use the Clumpak method (see details) [default TRUE].}

\item{plot_theme}{Theme for the plot. See Details for options
[default NULL].}

\item{colors_clusters}{A color palette for clusters (K) or a list with
as many colors as there are clusters (K) [default NULL].}

\item{ind_name}{Whether to plot individual names [default TRUE].}

\item{border_ind}{The width of the border line between individuals 
[default 0.25].}
}
\value{
List of Q-matrices
}
\description{
This function takes a fastStructure run object (output from
 \code{\link{gl.run.faststructure}}) and plots the typical structure bar
  plot that visualize the q matrix of a fastStructure run.
}
\details{
The function outputs a barplot which is the typical output of
 fastStructure.
 
 This function is based on the methods of CLUMPP and Clumpak as implemented 
 in the R package starmie (https://github.com/sa-lee/starmie). 
 
 The Clumpak method identifies sets of highly similar runs among 
 all the replicates of the same K. The method then separates the distinct 
 groups of runs representing distinct modes in the space of possible solutions.
 
 The CLUMPP method permutes the clusters output by independent runs of 
 clustering programs such as structure, so that they match up as closely as 
 possible.
 
 This function averages the replicates within each mode identified by the 
 Clumpak method.

Examples of other themes that can be used can be consulted in \itemize{
 \item \url{https://ggplot2.tidyverse.org/reference/ggtheme.html} and \item
 \url{https://yutannihilation.github.io/allYourFigureAreBelongToUs/ggthemes/}
 }
}
\examples{
\dontrun{
t1 <- gl.filter.callrate(platypus.gl,threshold = 1)
res <- gl.run.faststructure(t1, exec = "./fastStructure",k.range = 2:3, 
                          num.k.rep = 2,output = paste0(getwd(),"/res_str"))
qmat <- gl.plot.faststructure(res,k.range=2:3)
gl.map.structure(qmat, K=2, t1, scalex=1, scaley=0.5)
}
}
\references{
\itemize{
\item Raj, A., Stephens, M., & Pritchard, J. K. (2014). fastSTRUCTURE: 
variational inference of population structure in large SNP data sets. 
Genetics, 197(2), 573-589.
\item Pritchard, J.K., Stephens, M., Donnelly, P. (2000) Inference of
population structure using multilocus genotype data. Genetics 155, 945-959.
\item Kopelman, Naama M., et al. "Clumpak: a program for identifying 
clustering modes and packaging population structure inferences across K." 
Molecular ecology resources 15.5 (2015): 1179-1191.
\item Mattias Jakobsson and Noah A. Rosenberg. 2007. CLUMPP: a cluster
matching and permutation program for dealing with label switching and
multimodality in analysis of population structure. Bioinformatics
23(14):1801-1806. Available at
\href{http://web.stanford.edu/group/rosenberglab/clumppDownload.html}{clumpp}
}
}
\seealso{
\code{gl.run.faststructure}
}
\author{
Bernd Gruber & Luis Mijangos (Post to \url{https://groups.google.com/d/forum/dartr})
}
