% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.sim.WF.table.r
\name{gl.sim.WF.table}
\alias{gl.sim.WF.table}
\title{Creates the reference table for running gl.sim.WF.run}
\usage{
gl.sim.WF.table(
  file_var,
  x = NULL,
  file_targets_sel = NULL,
  file_r_map = NULL,
  interactive_vars = TRUE,
  seed = NULL,
  verbose = NULL,
  ...
)
}
\arguments{
\item{file_var}{Path of the variables file 'ref_variables.csv' (see details) 
[required if interactive_vars = FALSE].}

\item{x}{Name of the genlight object containing the SNP data to extract
values for some simulation variables (see details) [default NULL].}

\item{file_targets_sel}{Path of the file with the targets for selection (see 
details) [default NULL].}

\item{file_r_map}{Path of the file with the recombination map (see details)
[default NULL].}

\item{interactive_vars}{Run a shiny app to input interactively the values of
simulation variables [default TRUE].}

\item{seed}{Set the seed for the simulations [default NULL].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}

\item{...}{Any variable and its value can be added separately within the 
function, will be changed over the input value supplied by the csv file. See 
tutorial.}
}
\value{
Returns a list with the reference table used as input for the function
 \code{\link{gl.sim.WF.run}} and a table with the values variables used to 
 create the reference table.
}
\description{
This function creates a reference table to be used as input for the function
 \code{\link{gl.sim.WF.run}}. The created table has eight columns with the 
 following information for each locus to be simulated:
\itemize{ 
\item q - initial frequency.
\item h - dominance coefficient.
\item s - selection coefficient.
\item c - recombination rate.
\item loc_bp - chromosome location in base pairs.
\item loc_cM - chromosome location in centiMorgans.
\item chr_name - chromosome name.
\item type - SNP type.
} 

The reference table can be further modified as required. 

See documentation and tutorial for a complete description of the simulations.
These documents can be accessed at http://georges.biomatix.org/dartR
}
\details{
Values for the variables to create the reference table can be submitted into 
the function interactively through a Shiny app if interactive_vars = TRUE. 
Optionally, if interactive_vars = FALSE, values for variables can be 
submitted by using the csv file 'ref_variables.csv' which can be found by 
typing in the R console:
 system.file('extdata', 'ref_variables.csv', package ='dartR').
 
The values of the variables can be modified using the third column (“value”) 
of this file. 

If a genlight object is used as input for some of the simulation variables, 
this function access the information stored in the slots x$position and 
x$chromosome.

Examples of the format required for the recombination map file and the 
targets for selection file can be found by typing in the R console:
\itemize{ 
\item system.file('extdata', 'fly_recom_map.csv', package ='dartR')
\item system.file('extdata', 'fly_targets_of_selection.csv', package ='dartR')
}

To show further information of the variables in interactive mode, it might be
 necessary to call first: 'library(shinyBS)' for the information to be 
 displayed.
}
\examples{
ref_table <- gl.sim.WF.table(file_var=system.file('extdata', 
'ref_variables.csv', package = 'dartR'),interactive_vars = FALSE)
\dontrun{
#uncomment to run 
res_sim <- gl.sim.WF.run(file_var = system.file('extdata', 
'sim_variables.csv', package ='dartR'),ref_table=ref_table,
interactive_vars = FALSE)
}
}
\seealso{
\code{\link{gl.sim.WF.run}}

Other simulation functions: 
\code{\link{gl.sim.WF.run}()},
\code{\link{gl.sim.create_dispersal}()}
}
\author{
Custodian: Luis Mijangos -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{simulation functions}
