% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verboseApply.R
\name{verboseApply}
\alias{verboseApply}
\title{Verbose apply function}
\usage{
verboseApply(x, f, ..., .mc = 1, .mapper = mclapply, .bar = "none")
}
\arguments{
\item{x}{(vector)}

\item{f}{(function)}

\item{...}{arguments passed to \code{.mapper} and hence \code{f}}

\item{.mc}{(integer) the number of processes to start}

\item{.mapper}{(function) the actual apply function used. Should have an
argument \code{mc.cores}.}

\item{.bar}{(character) one in 'none', '.' or 'bar'}
}
\description{
This apply function has a progress bar and enables computations in
parallel. By default it is not verbose. As an interactive version with proper
'verbose' output by default please use \link{vmap}.
}
\examples{
\dontrun{
verboseApply(
  1:4,
  function(...) Sys.sleep(1),
  .bar = "bar",
  .mc = 2 
)
}
}
