% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_waterdata_daily.R
\name{read_waterdata_daily}
\alias{read_waterdata_daily}
\title{Get USGS Daily Data}
\usage{
read_waterdata_daily(
  monitoring_location_id = NA_character_,
  parameter_code = NA_character_,
  statistic_id = NA_character_,
  properties = NA_character_,
  time_series_id = NA_character_,
  approval_status = NA_character_,
  unit_of_measure = NA_character_,
  qualifier = NA_character_,
  value = NA,
  last_modified = NA_character_,
  skipGeometry = NA,
  time = NA_character_,
  bbox = NA,
  limit = NA,
  convertType = TRUE,
  no_paging = FALSE
)
}
\arguments{
\item{monitoring_location_id}{A unique identifier representing a single monitoring location. This corresponds to the \code{id} field in the \code{monitoring-locations} endpoint. Monitoring location IDs are created by combining the agency code of the agency responsible for the monitoring location (e.g. USGS) with the ID number of the monitoring location (e.g. 02238500), separated by a hyphen (e.g. USGS-02238500).

Multiple monitoring_location_ids can be requested as a character vector.}

\item{parameter_code}{Parameter codes are 5-digit codes used to identify the constituent measured and the units of measure. A complete list of parameter codes and associated groupings can be found at \url{https://api.waterdata.usgs.gov/ogcapi/v0/collections/parameter-codes/items}.

Multiple parameter_codes can be requested as a character vector.}

\item{statistic_id}{A code corresponding to the statistic an observation represents. Example codes include 00001 (max), 00002 (min), and 00003 (mean). A complete list of codes and their descriptions can be found at \url{https://api.waterdata.usgs.gov/ogcapi/v0/collections/statistic-codes/items}.

Multiple statistic_ids can be requested as a character vector.}

\item{properties}{A vector of requested columns to be returned from the query.
Available options are:
geometry, daily_id, time_series_id, monitoring_location_id, parameter_code, statistic_id, time, value, unit_of_measure, approval_status, qualifier, last_modified.
The default (\code{NA}) will return all columns of the data.}

\item{time_series_id}{A unique identifier representing a single time series. This corresponds to the \code{id} field in the \code{time-series-metadata} endpoint.

Multiple time_series_ids can be requested as a character vector.}

\item{approval_status}{Some of the data that you have obtained from this U.S. Geological Survey database may not have received Director's approval.  Any such data values are qualified as provisional and are subject to revision.  Provisional data are released on the condition that neither the USGS nor the United States Government may be held liable for any damages resulting from its use. This field reflects the approval status of each record, and is either "Approved", meaining processing review has been completed and the data is approved for publication, or "Provisional" and subject to revision. For more information about provisional data, go to \url{https://waterdata.usgs.gov/provisional-data-statement/}.}

\item{unit_of_measure}{A human-readable description of the units of measurement associated with an observation.}

\item{qualifier}{This field indicates any qualifiers associated with an observation, for instance if a sensor may have been impacted by ice or if values were estimated.}

\item{value}{The value of the observation. Values are transmitted as strings in the JSON response format in order to preserve precision.}

\item{last_modified}{The last time a record was refreshed in our database. This may happen due to regular operational processes and does not necessarily indicate anything about the measurement has changed.
You can query this field using date-times or intervals, adhering to RFC 3339, or using ISO 8601 duration objects. Intervals may be bounded or half-bounded (double-dots at start or end).
Examples:
\itemize{
\item A date-time: "2018-02-12T23:20:50Z"
\item A bounded interval: "2018-02-12T00:00:00Z/2018-03-18T12:31:12Z"
\item Half-bounded intervals: "2018-02-12T00:00:00Z/.." or "../2018-03-18T12:31:12Z"
\item Duration objects: "P1M" for data from the past month or "PT36H" for the last 36 hours
}

Only features that have a \code{last_modified} that intersects the value of datetime are selected.}

\item{skipGeometry}{This option can be used to skip response geometries for
each feature. The returning object will be a data frame with no spatial
information.}

\item{time}{The date an observation represents. You can query this field using date-times or intervals, adhering to RFC 3339, or using ISO 8601 duration objects. Intervals may be bounded or half-bounded (double-dots at start or end).
Examples:
\itemize{
\item A date-time: "2018-02-12T23:20:50Z"
\item A bounded interval: "2018-02-12T00:00:00Z/2018-03-18T12:31:12Z"
\item Half-bounded intervals: "2018-02-12T00:00:00Z/.." or "../2018-03-18T12:31:12Z"
\item Duration objects: "P1M" for data from the past month or "PT36H" for the last 36 hours
}

Only features that have a \code{time} that intersects the value of datetime are selected. If a feature has multiple temporal properties, it is the decision of the server whether only a single temporal property is used to determine the extent or all relevant temporal properties.

You can also use a vector of length 2: the first value being the starting date,
the second value being the ending date. NA's within the vector indicate a
half-bound date. For example, c("2024-01-01", NA) will return all data starting
at 2024-01-01.}

\item{bbox}{Only features that have a geometry that intersects the bounding
box are selected.The bounding box is provided as four or six numbers, depending
on whether the coordinate reference system includes a vertical axis (height or
depth). Coordinates are assumed to be in crs 4326. The expected format is a numeric
vector structured: c(xmin,ymin,xmax,ymax). Another way to think of it is c(Western-most longitude,
Southern-most latitude, Eastern-most longitude, Northern-most longitude).}

\item{limit}{The optional limit parameter is used to control the subset of the
selected features that should be returned in each page. The maximum allowable
limit is 50000. It may be beneficial to set this number lower if your internet
connection is spotty. The default (\code{NA}) will set the limit to the maximum
allowable limit for the service.}

\item{convertType}{logical, defaults to \code{TRUE}. If \code{TRUE}, the function
will convert the data to dates and qualifier to string vector.}

\item{no_paging}{logical, defaults to \code{FALSE}. If \code{TRUE}, the data will
be requested from a native csv format. This can be dangerous because the
data will cut off at 50,000 rows without indication that more data
is available. Use \code{TRUE} with caution.}
}
\description{
Daily data provide one data value to represent water conditions for the day. Throughout much of the history of the USGS, the primary water data available was daily data collected manually at the monitoring location once each day. With improved availability of computer storage and automated transmission of data, the daily data published today are generally a statistical summary or metric of the continuous data collected each day, such as the daily mean, minimum, or maximum value. Daily data are automatically calculated from the continuous data of the same parameter code and are described by parameter code and a statistic code. These data have also been referred to as “daily values” or “DV”.
}
\examples{
\dontshow{if (is_dataRetrieval_user()) withAutoprint(\{ # examplesIf}

\donttest{
site <- "USGS-02238500"
dv_data_sf <- read_waterdata_daily(monitoring_location_id = site,
                              parameter_code = "00060", 
                              time = c("2021-01-01", "2022-01-01"))
                              
dv_data_last_modified <- read_waterdata_daily(monitoring_location_id = site,
                              parameter_code = "00060",
                              last_modified = "P7D")

dv_data_trim <- read_waterdata_daily(monitoring_location_id = site,
                          parameter_code = "00060", 
                          properties = c("value",
                                         "time"),
                          time = c("2021-01-01", "2022-01-01"))

dv_data <- read_waterdata_daily(monitoring_location_id = site,
                           parameter_code = "00060",
                           skipGeometry = TRUE)
                        
dv_data_period <- read_waterdata_daily(monitoring_location_id = site,
                                  parameter_code = "00060",
                                  time = "P7D")

multi_site <- read_waterdata_daily(monitoring_location_id =  c("USGS-01491000",
                                                          "USGS-01645000"),
                              parameter_code = c("00060", "00010"),
                              time = c("2023-01-01", "2024-01-01"))
                              
dv_data_quick <- read_waterdata_daily(monitoring_location_id = site,
                                   parameter_code = "00060",
                                   no_paging = TRUE)
                                   
dv_post <- read_waterdata_daily(monitoring_location_id = site,
                                approval_status = c("Approved", "Provisional"))

}
\dontshow{\}) # examplesIf}
}
