% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/con_contradictions_redcap.R
\name{con_contradictions_redcap}
\alias{con_contradictions_redcap}
\title{Checks user-defined contradictions in study data}
\usage{
con_contradictions_redcap(
  study_data,
  item_level = "item_level",
  label_col,
  threshold_value,
  meta_data_cross_item = "cross-item_level",
  use_value_labels,
  summarize_categories = FALSE,
  meta_data = item_level,
  cross_item_level,
  `cross-item_level`,
  meta_data_v2
)
}
\arguments{
\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{item_level}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{threshold_value}{\link{numeric} from=0 to=100. a numerical value
ranging from 0-100}

\item{meta_data_cross_item}{\link{data.frame} contradiction rules table.  Table
defining contradictions. See
\href{https://dataquality.qihs.uni-greifswald.de/VIN_Cross_Item_Level_Metadata.html}{online documentation}
for its required structure.}

\item{use_value_labels}{\link{logical} Deprecated in favor of \link{DATA_PREPARATION}.
If set to \code{TRUE}, labels can be used in the
\code{REDCap} syntax to specify contraction checks for
categorical variables. If set to \code{FALSE},
contractions have to be specified using the coded
values. In case that this argument is not set in
the function call, it will be set to \code{TRUE} if
the metadata contains a column \code{VALUE_LABELS}
which is not empty.}

\item{summarize_categories}{\link{logical} Needs a column \code{CONTRADICTION_TYPE} in
the \code{meta_data_cross_item}.
If set, a summary output is generated for the
defined categories plus one plot per
category. TODO: Not yet controllable by metadata.}

\item{meta_data}{\link{data.frame} old name for \code{item_level}}

\item{cross_item_level}{\link{data.frame} alias for \code{meta_data_cross_item}}

\item{meta_data_v2}{\link{character} path to workbook like metadata file, see
\code{\link{prep_load_workbook_like_file}} for details.
\strong{ALL LOADED DATAFRAMES WILL BE PURGED},
using \code{\link{prep_purge_data_frame_cache}},
if you specify \code{meta_data_v2}.}

\item{`cross-item_level`}{\link{data.frame} alias for \code{meta_data_cross_item}}
}
\value{
If \code{summarize_categories} is \code{FALSE}:
A \link{list} with:
\itemize{
\item \code{FlaggedStudyData}: The first output of the contradiction function is a
data frame of similar dimension regarding the number
of observations in the study data. In addition, for
each applied check on the variables an additional
column is added which flags observations with a
contradiction given the applied check.
\item \code{VariableGroupData}: The second output summarizes this information
into one
data frame. This output can be used to provide an
executive overview on the amount of contradictions.
\item \code{VariableGroupTable}: A subset of \code{VariableGroupData} used within the
pipeline.
\item \code{SummaryPlot}: The third output visualizes summarized information
of \code{SummaryData}.
}

If \code{summarize_categories} is \code{TRUE}, other objects are returned:
A list with one element \code{Other}, a list with the following entries:
One per category named by that category (e.g. "Empirical") containing a
result for contradiction checks within that category only. Additionally, in the
slot \code{all_checks}, a result as it would have been returned with
\code{summarize_categories} set to \code{FALSE}. Finally, in
the top-level list, a slot \code{SummaryData} is
returned containing sums per Category and an according \link[ggplot2:ggplot]{ggplot2::ggplot} in
\code{SummaryPlot}.
}
\description{
This approach considers a contradiction if impossible combinations of data
are observed in one participant. For example, if age of a participant is
recorded repeatedly the value of age is (unfortunately) not able to decline.
Most cases of contradictions rest on comparison of two variables.

Important to note, each value that is used for comparison may represent a
possible characteristic but the combination of these two values is considered
to be impossible. The approach does not consider implausible or inadmissible
values.

\link{Indicator}
}
\details{
\subsection{Algorithm of this implementation:}{
\itemize{
\item Remove missing codes from the study data (if defined in the metadata)
\item Remove measurements deviating from limits defined in the metadata
\item Assign label to levels of categorical variables (if applicable)
\item Apply contradiction checks (given as \code{REDCap}-like rules in a separate
metadata table)
\item Identification of measurements fulfilling contradiction rules. Therefore
two output data frames are generated:
\itemize{
\item on the level of observation to flag each contradictory value
combination, and
\item a summary table for each contradiction check.
}
\item A summary plot illustrating the number of contradictions is generated.
}

List function.
}
}
\seealso{
\href{https://dataquality.qihs.uni-greifswald.de/VIN_con_impl_contradictions_redcap.html}{Online Documentation for the function}
\link{meta_data_cross}
\href{https://dataquality.qihs.uni-greifswald.de/Cross_Item_Level_Metadata.html}{Online Documentation for the required cross-item-level metadata}
}
