% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decade.R
\name{plot_weekly_cycle}
\alias{plot_weekly_cycle}
\title{Plot weekly cycle}
\usage{
plot_weekly_cycle(dailypcp, outpath, p = 0.95)
}
\arguments{
\item{dailypcp}{A character vector giving the paths of the input files, or
a list of 5-column matrices with following columns: variable code (must be 'rr'),   
year, month, day, value. The names of the list elements are assumed to be
the station IDs.}

\item{outpath}{Character string giving the path for the output files.}

\item{p}{Probability threshold for the binomial test (default is 0.95).}
}
\description{
Check if there is a significant weekly cycle in daily precipitation data by
means of a binomial test.
}
\details{
The input files must follow the C3S Station Exchange Format (SEF).

Creates one pdf for each station ('weekly.ID.pdf') plus one pdf with an overview 
of the entire dataset ('weekly.pdf').
}
\examples{
plot_weekly_cycle(list(Rosario = Rosario$rr), outpath = tempdir())

}
\references{
Hunziker et al., 2017: Identifying, attributing, and overcoming common data quality 
issues of manned station observations. Int. J. Climatol, 37: 4131-4145.

Hunziker et al., 2018: Effects of undetected data quality issues on climatological
analyses. Clim. Past, 14: 1-20.
}
\author{
Stefan Hunziker, Yuri Brugnara
}
