% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onsides_parser.R
\name{parseOnSIDES}
\alias{parseOnSIDES}
\title{Parse the OnSIDES Core Relational Database}
\usage{
parseOnSIDES(
  dataDir,
  include_high_confidence = TRUE,
  db_version = NULL,
  db_exported_date = NULL
)
}
\arguments{
\item{dataDir}{A string specifying the path to the directory containing the
OnSIDES CSV files.}

\item{include_high_confidence}{Logical. If TRUE (the default), the function
will also parse the `high_confidence.csv` file, which is a pre-aggregated
summary of ingredient-to-effect relationships. If the file is not found,
a warning is issued.}

\item{db_version}{used onside version (default = NULL)}

\item{db_exported_date}{used onside release date (default = NULL)}
}
\value{
dvobject
}
\description{
Parses the core relational tables from the OnSIDES database.
}
\seealso{
Other parsers: 
\code{\link{cett_nodes_options}()},
\code{\link{drug_node_options}()},
\code{\link{parseDrugBank}()},
\code{\link{parseTWOSIDES}()},
\code{\link{references_node_options}()}

Other parsers: 
\code{\link{cett_nodes_options}()},
\code{\link{drug_node_options}()},
\code{\link{parseDrugBank}()},
\code{\link{parseTWOSIDES}()},
\code{\link{references_node_options}()}
}
\concept{parsers}
