% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialization.R
\name{initialize_hclust}
\alias{initialize_hclust}
\title{Estimate an initial binary tree on latent classes using hclust()}
\usage{
initialize_hclust(
  leaf_data,
  c,
  c_order = 1,
  method_dist = "euclidean",
  method_hclust = "ward.D",
  method_add_root = "min_cor",
  alpha = 0,
  theta = 0,
  ...
)
}
\arguments{
\item{leaf_data}{a K by J matrix of \eqn{logit(theta_{kj})}}

\item{c}{hyparameter of divergence function a(t)}

\item{c_order}{equals 1 (default) or 2 to choose divergence function}

\item{method_dist}{string specifying the distance measure to be used in dist().
This must be one of "euclidean", "maximum", "manhattan", "canberra", "binary" or "minkowski".
Any unambiguous substring can be given.}

\item{method_hclust}{string specifying the distance measure to be used in hclust().
This should be (an unambiguous abbreviation of) one of "ward.D", "ward.D2", "single",
"complete", "average" (= UPGMA), "mcquitty" (= WPGMA), "median" (= WPGMC) or
"centroid" (= UPGMC).}

\item{method_add_root}{string specifying the method to add the initial branch to the tree
output from hclust(). This should be one of "min_cor" (the absolute value of the minimum
between-class correlation) or "sample_ddt" (randomly sample a small divergence time from
the DDT process with a large c = 100)}

\item{alpha, theta}{hyparameter of branching probability a(t) Gamma(m-alpha) / Gamma(m+1+theta)
For DDT, alpha = theta = 0}

\item{...}{optional arguments for the poLCA function}
}
\value{
phylo4d object of tree topology
}
\description{
Estimate an initial binary tree on latent classes using hclust()
}
\seealso{
Other initialization functions: 
\code{\link{initialize}()},
\code{\link{initialize_poLCA}()}
}
\concept{initialization functions}
