% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_DDT_functions.R
\name{simulate_lcm_response}
\alias{simulate_lcm_response}
\title{Simulate multivariate binary responses from a latent class model}
\usage{
simulate_lcm_response(N, response_prob, class_probability)
}
\arguments{
\item{N}{number of individuals}

\item{response_prob}{a K by J matrix, where the k,j-th element is the response
probability of item j for individuals in class k}

\item{class_probability}{a length K vector, where the k-th element is the
probability of assigning an individual to class k. It does not have to sum up to 1}
}
\value{
a named list of the following elements:
\describe{
\item{\code{response_matrix}}{a K by J matrix with entries between \code{0} and \code{1} for the item
response probabilities.}
\item{\code{class_probability}}{a K-vector with entries between 0 and 1 for the class
probabilities. Entries should be nonzero and sum up to 1, or otherwise will be normalized}
}
}
\description{
Generate multivariate binary responses from the following process:
For individual i = 1, ..., N, draw \eqn{Z_i} from Categorical distribution with prior class probability (length K).
For item j = 1, ..., J, given \eqn{Z_i = k}, draw \eqn{Y_{ij}} from Binomial with class-item probability
}
\examples{
# number of latent classes
K <- 6
# number of items
J <- 78
response_prob <- matrix(runif(K*J), nrow = K)
class_probability <- rep(1/K, K)
# number of individuals
N <- 100
response_matrix <- simulate_lcm_response(N, response_prob, class_probability)
}
\seealso{
Other simulate DDT-LCM data: 
\code{\link{simulate_DDT_tree}()},
\code{\link{simulate_lcm_given_tree}()},
\code{\link{simulate_parameter_on_tree}()}
}
\concept{simulate DDT-LCM data}
