% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers_great-circle-layer.R
\name{add_great_circle_layer}
\alias{add_great_circle_layer}
\title{Add a great circle layer to the deckgl widget}
\usage{
add_great_circle_layer(
  deckgl,
  data = NULL,
  properties = list(),
  ...,
  id = "great-circle-layer"
)
}
\arguments{
\item{deckgl}{A deckgl widget object.}

\item{data}{The url to fetch data from or a data object.}

\item{properties}{A named list of properties with names corresponding to the properties defined
in the \href{https://deck.gl/#/documentation/deckgl-api-reference}{deckgl-api-reference}
for the given layer class. The \code{properties} parameter can also be an empty list. In this case
all props must be passed as named arguments.}

\item{...}{Named arguments that will be added to the \code{properties} object. Identical parameters
are overwritten.}

\item{id}{The unique id of the layer.}
}
\description{
The \code{GreatCircleLayer} is a variation of the \code{ArcLayer}.
It renders flat arcs along the great circle joining pairs of source
and target points, specified as latitude/longitude coordinates.
}
\examples{
## @knitr great-circle-layer
data("bart_segments")

properties <- list(
  pickable = TRUE,
  getWidth = 12,
  getSourcePosition = ~from_lng + from_lat,
  getTargetPosition = ~to_lng + to_lat,
  getSourceColor = JS("d => [Math.sqrt(d.inbound), 140, 0]"),
  getTargetColor = JS("d => [Math.sqrt(d.outbound), 140, 0]"),
  getTooltip = "{{from_name}} to {{to_name}}"
)

deck <- deckgl(zoom = 10, pitch = 35) \%>\%
  add_great_circle_layer(data = bart_segments, properties = properties) \%>\%
  add_control("Great Circle Layer") \%>\%
  add_basemap()

if (interactive()) deck
}
\seealso{
\url{https://deck.gl/#/documentation/deckgl-api-reference/layers/great-circle-layer}
}
