% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers_h3-hexagon-layer.R
\name{add_h3_hexagon_layer}
\alias{add_h3_hexagon_layer}
\title{Add a h3 hexagon layer to the deckgl widget}
\usage{
add_h3_hexagon_layer(
  deckgl,
  data = NULL,
  properties = list(),
  ...,
  id = "h3-hexagon-layer"
)
}
\arguments{
\item{deckgl}{A deckgl widget object.}

\item{data}{The url to fetch data from or a data object.}

\item{properties}{A named list of properties with names corresponding to the properties defined
in the \href{https://deck.gl/#/documentation/deckgl-api-reference}{deckgl-api-reference}
for the given layer class. The \code{properties} parameter can also be an empty list. In this case
all props must be passed as named arguments.}

\item{...}{Named arguments that will be added to the \code{properties} object. Identical parameters
are overwritten.}

\item{id}{The unique id of the layer.}
}
\description{
Add a h3 hexagon layer to the deckgl widget
}
\examples{
## @knitr h3-hexagon-layer-layer
h3_cells <- system.file("sample-data/h3-cells.csv", package = "deckgl") \%>\%
  read.csv()

properties <- list(
  getHexagon = ~h3_index,
  getFillColor =JS("d => [255, (1 - d.count / 500) * 255, 0]"),
  getElevation = ~count,
  elevationScale = 20,
  getTooltip = "{{h3_index}}: {{count}}"
)

deck <- deckgl(zoom = 11, pitch = 35) \%>\%
  add_h3_hexagon_layer(data = h3_cells, properties = properties) \%>\%
  add_control("H3 Hexagon Layer") \%>\%
  add_basemap()

if (interactive()) deck
}
\seealso{
\url{https://deck.gl/#/documentation/deckgl-api-reference/layers/h3-hexagon-layer}
}
