% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deepspat_main_MSP.R
\name{deepspat_MSP}
\alias{deepspat_MSP}
\title{Deep compositional spatial model for max-stable processes}
\usage{
deepspat_MSP(
  f,
  data,
  layers = NULL,
  method = c("MPL", "MRPL", "WLS"),
  par_init = initvars(),
  learn_rates = init_learn_rates(),
  family = c("power_stat", "power_nonstat"),
  dtype = "float64",
  nsteps = 100L,
  nsteps_pre = 100L,
  edm_emp = NULL,
  p = c(0, 1),
  pen_coef = 0,
  show = TRUE,
  ...
)
}
\arguments{
\item{f}{A formula identifying the dependent variable(s) and the spatial inputs. Use \code{get_depvars_multivar3} to extract the dependent variable names.}

\item{data}{A data frame containing the required data.}

\item{layers}{A list containing the warping layers; required for non-stationary models (i.e., when \code{family = "power_nonstat"}).}

\item{method}{A character string specifying the estimation method. Must be one of \code{"MPL"}, \code{"MRPL"}, or \code{"WLS"} for max-stable Brown-Resnick processes}

\item{par_init}{A list of initial parameter values. Call the function \code{initvars()} to see the structure of the list.}

\item{learn_rates}{A list of learning rates for the various quantities in the model. Call the function \code{init_learn_rates()}
to see the structure of the list.}

\item{family}{A character string specifying the spatial dependence model. Use \code{"power_nonstat"} for non-stationary models
and \code{"sta"} for stationary models.}

\item{dtype}{A character string indicating the data type for TensorFlow computations (\code{"float32"} or \code{"float64"}).
Default is \code{"float32"}}

\item{nsteps}{An integer specifying the number of training steps for dependence parameter learning.}

\item{nsteps_pre}{An integer specifying the number of pre-training steps for warping layer parameters.}

\item{edm_emp}{For the WLS method, a numeric vector or matrix providing an empirical extremal coefficients.}

\item{p}{For pairwise likelihood based methods, p is used to specify the size of pair subset for pairwise likelihood,
or the probability parameter of Bernoulli r.v. for randomized pairwise likelihood.}

\item{pen_coef}{A penalty parameter for weights of SR-RBF(2) to relieve overfitting.}

\item{show}{Logical; if \code{TRUE} progress information is printed during training.}

\item{...}{Currently unused.}
}
\value{
\code{deepspat_MSP} returns an object of class \code{deepspat_MSP} which is a list containing the following components:
\describe{
  \item{\code{layers}}{The list of warping layers used in the model.}
  \item{\code{Cost}}{The final cost value after training (e.g., negative log-likelihood, least squares, or gradient score).}
  \item{\code{transeta_tf}}{TensorFlow objects for the transformed dependence parameters in the warping layers.}
  \item{\code{eta_tf}}{TensorFlow objects for the warped dependence parameters.}
  \item{\code{a_tf}}{TensorFlow object for the parameters of the LFT layers (if applicable).}
  \item{\code{logphi_tf}}{TensorFlow variable representing the logarithm of the spatial range parameter.}
  \item{\code{logitkappa_tf}}{TensorFlow variable representing the logit-transformed degrees of freedom.}
  \item{\code{scalings}}{A list of scaling limits (minima and maxima) for the input and warped spatial coordinates.}
  \item{\code{s_tf}}{TensorFlow object for the scaled spatial coordinates.}
  \item{\code{z_tf}}{TensorFlow object for the observed response values.}
  \item{\code{swarped_tf}}{List of TensorFlow objects representing the warped spatial coordinates at each layer.}
  \item{\code{swarped}}{Matrix of final warped spatial coordinates.}
  \item{\code{method}}{The estimation method used (\code{"MPL"}, \code{"MRPL"}, or \code{"WLS"}).}
  \item{\code{family}}{The spatial dependence family (\code{"power_stat"} or \code{"power_nonstat"}).}
  \item{\code{dtype}}{The data type used in TensorFlow computations.}
  \item{\code{nlayers}}{Number of warping layers (for non-stationary models).}
  \item{\code{f}}{The model formula.}
  \item{\code{data}}{The data frame used for model fitting.}
  \item{\code{ndata}}{Number of observations in \code{data}.}
  \item{\code{negcost}}{Vector of cost values recorded during training.}
  \item{\code{pairs_tf}}{TensorFlow variable representing the spatial location pairs
    (and, for MRPL, the replicate indices) used in the pairwise / randomized pairwise
    likelihood or WLS objective..}
  \item{\code{p}}{Input size of pair subset for pairwise likelihood, 
    or the parameter of Bernoulli r.v. for randomized pairwise likelihood.}
  \item{\code{time}}{Elapsed time for model fitting.}
}
}
\description{
Constructs an extended deep compositional spatial model that supports different estimation methods
  ("MPL", "MRPL", or "WLS") and spatial dependence families (stationary or non-stationary). This function extends the
  basic deepspat model by incorporating additional dependence modeling and pre-training steps for the warping layers.
}
