% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deepspat_main_nn_ST_GP.R
\name{deepspat_nn_ST_GP}
\alias{deepspat_nn_ST_GP}
\title{Deep compositional spatio-temporal model (with nearest neighbors) for Gaussian processes}
\usage{
deepspat_nn_ST_GP(
  f,
  data,
  g = ~1,
  layers_spat = NULL,
  layers_temp = NULL,
  m = 25L,
  order_id,
  nn_id,
  method = c("REML"),
  family = c("exp_stat_sep", "exp_stat_asym", "exp_nonstat_sep", "exp_nonstat_asym"),
  par_init = initvars(),
  learn_rates = init_learn_rates(),
  nsteps = 150L
)
}
\arguments{
\item{f}{formula identifying the dependent variables and the spatial inputs in the covariance}

\item{data}{data frame containing the required data}

\item{g}{formula identifying the independent variables in the linear trend}

\item{layers_spat}{list containing the spatial warping layers}

\item{layers_temp}{list containing the temporal warping layers}

\item{m}{number of nearest neighbors}

\item{order_id}{indices of the order of the observations}

\item{nn_id}{indices of the nearest neighbors of the ordered observations}

\item{method}{identifying the method for finding the estimates}

\item{family}{identifying the family of the model constructed}

\item{par_init}{list of initial parameter values. Call the function \code{initvars()} to see the structure of the list}

\item{learn_rates}{learning rates for the various quantities in the model. Call the function \code{init_learn_rates()} to see the structure of the list}

\item{nsteps}{number of steps when doing gradient descent times two or three (depending on the family of model)}
}
\value{
\code{deepspat_nn_ST_GP} returns an object of class \code{deepspat_nn_ST_GP} with the following items
\describe{
 \item{"f"}{The formula used to construct the covariance model}
 \item{"g"}{The formula used to construct the linear trend model}
 \item{"data"}{The data used to construct the deepspat model}
 \item{"X"}{The model matrix of the linear trend}
 \item{"layers_spat"}{The spatial warping function layers in the model}
 \item{"layers_temp"}{The temporal warping function layers in the model}
 \item{"Cost"}{The final value of the cost}
 \item{"family"}{Family of the model}
 \item{"eta_tf"}{Estimated weights in the spatial warping layers as a list of \code{TensorFlow} objects}
 \item{"eta_t_tf"}{Estimated weights in the temporal warping layers as a list of \code{TensorFlow} objects}
 \item{"a_tf"}{Estimated parameters in the LFT layers}
 \item{"beta"}{Estimated coefficients of the linear trend}
 \item{"precy_tf"}{Precision of measurement error, as a \code{TensorFlow} object}
 \item{"sigma2_tf"}{Variance parameter in the covariance matrix, as a \code{TensorFlow} object}
 \item{"v_tf"}{Parameters of the covariance matrix (indicating asymmetric spatio-temporal covariance)}
 \item{"l_tf"}{Length scale (for spatial dimension) parameter in the covariance matrix, as a \code{TensorFlow} object}
 \item{"l_t_tf"}{Length scale (for temporal dimension) parameter in the covariance matrix, as a \code{TensorFlow} object}
 \item{"scalings"}{Minima and maxima used to scale the unscaled unit outputs for each spatial warping layer, as a list of \code{TensorFlow} objects}
 \item{"scalings_t"}{Minima and maxima used to scale the unscaled unit outputs for each temporal warping layer, as a list of \code{TensorFlow} objects}
 \item{"method"}{Method used for inference}
 \item{"nlayers_spat"}{Number of spatial warping layers in the model}
 \item{"nlayers_temp"}{Number of temporal warping layers in the model}
 \item{"swarped_tf"}{Spatial locations on the warped domain}
 \item{"twarped_tf"}{Temporal locations on the warped domain}
 \item{"negcost"}{Vector of costs after each gradient-descent evaluation}
 \item{"z_tf"}{Data of the process}
 \item{"m"}{The number of nearest neighbors}
 }
}
\description{
Constructs a deep compositional spatio-temporal model (with nearest neighbors)
}
