% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdegross.R
\name{pdegross}
\alias{pdegross}
\title{Cumulative distribution function (cdf) based on an object resulting from the estimation procedure in \link{degross}.}
\usage{
pdegross(x, degross.fit, phi)
}
\arguments{
\item{x}{Scalar or vector where the fitted cdf must be evaluated.}

\item{degross.fit}{A \code{\link{degross.object}} generated using \link{degross} and containing the density estimation results.}

\item{phi}{(Optional) vector of spline parameters for the log density (default: \code{degross.fit$phi} if missing).}
}
\value{
a scalar or vector of the same length as \code{x} containing the value of the fitted cdf at \code{x}.
}
\description{
Cumulative distribution function (cdf) based on an object resulting from the estimation procedure in \link{degross}.
}
\examples{
## Generate grouped data
sim = simDegrossData(n=3500, plotting=TRUE, choice=2)

## Create a degrossData object
obj.data = degrossData(Big.bins=sim$Big.bins, freq.j=sim$freq.j, m.j=sim$m.j)
print(obj.data)

## Estimate the density
obj.fit = degross(obj.data)

## Superpose the fitted cdf using the <pdegross> function
with(sim, curve(true.cdf(x),min(Big.bins),max(Big.bins),
     col="red",lwd=2, ylab="F(x)"))
curve(pdegross(x,obj.fit),add=TRUE,lty="dashed")
legend("topleft", legend=c("Target cdf","Estimated cdf"), lwd=2,
       lty=c("solid","dashed"), col=c("red","black"), box.lty=0, inset=.04)

}
\references{
Lambert, P. (2021) Moment-based density and risk estimation from grouped summary statistics. arXiv:2107.03883.
}
\seealso{
\code{\link{degross.object}}, \code{\link{ddegross}}, \code{\link{qdegross}}, \code{\link{degross}}.
}
\author{
Philippe Lambert \email{p.lambert@uliege.be}
}
