% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_SC_output.R
\name{plot_SC_output}
\alias{plot_SC_output}
\title{Plotting output of stem cycle approach (i.e., output of phase.sc function).}
\usage{
plot_SC_output(
  SC_output,
  DOY,
  Year,
  cols = c("#fee8c8", "#fdbb84", "#e34a33"),
  phNames = c("Shrinkage", "Expansion", "Increment")
)
}
\arguments{
\item{SC_output}{list the output of \code{phase.sc} function.}

\item{DOY}{array with initial and final day for plotting. E.g. \emph{c(a,b)}, where a = initial date and b = final date.}

\item{Year}{array for indicating year for plotting.}

\item{cols}{array of three elements: colour for each phases.}

\item{phNames}{array with three elements for three different phases. Default is \strong{"Shrinkage", "Expansion" and "Increment"}.}
}
\value{
A plot with different phases.
}
\description{
This function plots the stem cycle of dendrometer data.
}
\examples{
\donttest{
library(dendRoAnalyst)
data(gf_nepa17)
sc.phase<-phase.sc(df=gf_nepa17, TreeNum=1, smoothing=12)
plot_SC_output(SC_output=sc.phase,DOY=c(50,60), Year=2017)
}

}
