% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendrometry.R
\name{param}
\alias{param}
\title{Structural parameters for stands}
\usage{
param(
  data,
  ...,
  plot = "",
  DBH = "",
  height = "",
  crown = "",
  area = NULL,
  k = 100,
  kCrown = 1
)
}
\arguments{
\item{data}{a data frame, list, tibble or object coercible by
\code{\link{as.data.frame}} to a data frame containing the forest inventory
variables.}

\item{...}{additional character strings specifying grouping variables
(factors) in \code{data}. Results will be nested by these factors.}

\item{plot}{optional character, name of the variable containing plot identifiers.
If empty (""), all data is treated as a single plot.}

\item{DBH}{optional, character, name of the variable containing diameter at breast
height measurements.}

\item{height}{optional, character, name of the variable containing tree height
measurements.}

\item{crown}{optional, character, name of the variable containing crown diameter
measurements.}

\item{area}{optional, numeric value of plot area, or character name of variable
containing plot areas. If NULL, density calculations are omitted.}

\item{k}{numeric, conversion factor for basal area calculation (default: 100).}

\item{kCrown}{numeric, conversion factor for crown basal area calculation
(default: 1).}
}
\value{
A nested list structure containing calculated parameters for each
group. Parameters include:
\itemize{
  \item \code{MeanDBH}: Mean diameter at breast height
  \item \code{Basal}: Basal area per unit area
  \item \code{MeanCrown}: Mean crown diameter
  \item \code{BasalCrown}: Crown basal area per unit area
  \item \code{Height}: Mean height
  \item \code{LoreyHeight}: Lorey's height (basal area weighted mean height)
  \item \code{Density}: Number of trees per unit area
}
}
\description{
Computes various forest stand parameters (basal area, mean diameter, height, etc.)
for forest inventory data, with support for grouping by multiple factors and
plot-level analysis.
}
\details{
The function supports hierarchical grouping by multiple factors. For example,
grouping by species and site will create a nested structure where parameters
are calculated for each species within each site.

If plot-level analysis is requested (plot != ""), the function will further
subdivide each group by plot and calculate parameters for each plot within
each group. Else, it treats the entire dataset as a single plot; area should
then be specified accordingly.

Blackman and Green indices are returned if combinations of specified factors
contain more than one plot. Otherwise, the right (correct) ones are returned as attributes.
}
\examples{
param(
  data = Logging, plot = "tree", DBH = "diametreMedian",
  height = "hauteur", crown = "perimetreBase", area = 0.03, kCrown = 100
)

set.seed(123)
Logging$surperficie <- abs(rnorm(24, mean = 0.03, sd = 0.01))
head(Logging)

param(
  data = Logging, plot = "tree", DBH = "diametreMedian",
  height = "hauteur", crown = "perimetreBase", area = "surperficie", kCrown = 100
)

\dontrun{
# Basic usage - single plot
params <- param(forest_data, DBH = "dbh", height = "height", area = 1000)

# Multiple plots
params <- param(forest_data,
  plot = "plot_id", DBH = "dbh",
  height = "height", area = "plot_area"
)

# Grouped analysis
params <- param(forest_data,
  plot = "plot_id", DBH = "dbh",
  height = "height", area = 1000,
  "species", "site", "treatment"
)

# Access specific results
oak_site1 <- params$oak$site1
}

}
