% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.ulsif}
\alias{predict.ulsif}
\title{Obtain predicted density ratio values from a \code{ulsif} object}
\usage{
\method{predict}{ulsif}(
  object,
  newdata = NULL,
  sigma = c("sigmaopt", "all"),
  lambda = c("lambdaopt", "all"),
  ...
)
}
\arguments{
\item{object}{A \code{ulsif} object}

\item{newdata}{Optional \code{matrix} new data set to compute the density}

\item{sigma}{A scalar with the Gaussian kernel width}

\item{lambda}{A scalar with the regularization parameter}

\item{...}{Additional arguments to be passed to the function}
}
\value{
An array with predicted density ratio values from possibly new data,
but otherwise the numerator samples.
}
\description{
Obtain predicted density ratio values from a \code{ulsif} object
}
\examples{
set.seed(123)
# Fit model
dr <- ulsif(numerator_small, denominator_small)
# Inspect model object
dr
# Obtain summary of model object
summary(dr)
# Plot model object
plot(dr)
# Plot density ratio for each variable individually
plot_univariate(dr)
# Plot density ratio for each pair of variables
plot_bivariate(dr)
# Predict density ratio and inspect first 6 predictions
head(predict(dr))
# Fit model with custom parameters
ulsif(numerator_small, denominator_small, sigma = 2, lambda = 2)
}
\seealso{
\code{\link{predict}}, \code{\link{ulsif}}
}
\keyword{predict}
\keyword{ulsif}
