% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desbeta.R
\name{desbeta}
\alias{desbeta}
\title{Calculate skewness and kurtosis based on Beta distribution in one group}
\usage{
desbeta(
  vmean,
  vsd,
  lo,
  hi,
  method = "MM",
  rawdata = NULL,
  showFigure = FALSE,
  ...
)
}
\arguments{
\item{vmean}{sample mean of the truncated data}

\item{vsd}{sample standard deviation of the truncated data}

\item{lo}{minimum possible value}

\item{hi}{maximum possible value}

\item{method}{when method = 'MM', the method used is the method of moments, when method = "ML', the method used to estimate the distribution is maximum likelihood}

\item{rawdata}{when raw data is available, we could still use it to check it figuratively, if the data was closed to the normal distribution, or truncated normal distribution.}

\item{showFigure}{when showFigure = TRUE, it will display the plots with theoretical normal curve and the truncated normal curve.}

\item{...}{other arguments}
}
\value{
If `showFigure = TRUE`, the output will be a list with two objects: one is the data frame of shape parameters (alpha and beta), mean and standard deviation of standard beta distribution (mean and sd), and skewness and kurtosis; the other is the theoretical figures of beta and normal distributions. If `showFigure = FALSE`, the output will be only the data frame.
}
\description{
This function can be used to calculate the skewness and kurtosis based on the Beta distribution. Also, this function estimate the shape parameters alpha and beta.
}
\examples{
data('beta_mdat')
desbeta(vmean=beta_mdat$m2[6], vsd=beta_mdat$sd2[6],
hi = beta_mdat$hi2[6], lo = beta_mdat$lo2[6], showFigure = TRUE)

}
\references{
\insertRef{johnson1995continuous}{detectnorm}

\insertRef{smithson2006better}{detectnorm}
}
\seealso{
\code{\link{destrunc}}
}
