% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diathor-package.R
\docType{package}
\name{diathor-package}
\alias{diathor-package}
\title{diathor: Calculate Ecological Information and Diatom Based Indices}
\description{
Calculate multiple biotic indices using diatoms from environmental samples. Diatom species are recognized by their species' name using a heuristic search, and their ecological data is retrieved from multiple sources. It includes number/shape of chloroplasts diversity indices, size classes, ecological guilds, and multiple biotic indices. It outputs both a dataframe with all the results and plots of all the obtained data in a defined output folder. - Sample data was taken from Nicolosi Gelis, Cochero & Gómez (2020, \doi{10.1016/j.ecolind.2019.105951}). - The package uses the 'Diat.Barcode' database to calculate morphological and ecological information by Rimet & Couchez (2012, \doi{10.1051/kmae/2012018}),and the combined classification of guilds and size classes established by B-Béres et al. (2017, \doi{10.1016/j.ecolind.2017.07.007}). - Current diatom-based biotic indices include the DES index by Descy (1979) - EPID index by Dell'Uomo (1996, ISBN: 3950009002) - IDAP index by Prygiel & Coste (1993, \doi{10.1007/BF00028033}) - ID-CH index by Hürlimann & Niederhauser (2007) - IDP index by Gómez & Licursi (2001, \doi{10.1023/A:1011415209445}) - ILM index by Leclercq & Maquet (1987) - IPS index by Coste (1982) - LOBO index by Lobo, Callegaro, & Bender (2002, ISBN:9788585869908) - SLA by Sládeček (1986, \doi{10.1002/aheh.19860140519}) - TDI index by Kelly, & Whitton (1995, \doi{10.1007/BF00003802}) - SPEAR(herbicide) index by Wood, Mitrovic, Lim, Warne, Dunlop, & Kefford (2019, \doi{10.1016/j.ecolind.2018.12.035}) - PBIDW index by Castro-Roa & Pinilla-Agudelo (2014) - DISP index by Stenger-Kovács et al. (2018, \doi{10.1016/j.ecolind.2018.07.026}) - EDI index by Chamorro et al. (2024, \doi{10.1021/acsestwater.4c00126}) - DDI index by Álvarez-Blanco et al. (2013, \doi{ 10.1007/s10661-012-2607-z}) - PDISE index by Kahlert et al. (2023, \doi{10.1007/s10661-023-11378-4}).
}
\author{
\strong{Maintainer}: Joaquin Cochero \email{jcochero@ilpla.edu.ar} (\href{https://orcid.org/0000-0003-3957-6819}{ORCID})

Authors:
\itemize{
  \item Maria Mercedes Nicolosi Gelis \email{mercedesnicolosi@ilpla.edu.ar} (\href{https://orcid.org/0000-0001-6324-7930}{ORCID})
  \item Maria Belen Sathicq \email{mbelen@ilpla.edu.ar} (\href{https://orcid.org/0000-0002-3534-8950}{ORCID})
}

}
\keyword{internal}
