% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diceplot.R
\name{dice_plot}
\alias{dice_plot}
\title{Dice Plot Visualization}
\usage{
dice_plot(
  data,
  x = NULL,
  y = NULL,
  z = NULL,
  group = NULL,
  group_alpha = 0.5,
  title = NULL,
  z_colors = NULL,
  group_colors = NULL,
  custom_theme = theme_minimal(),
  max_dot_size = 5,
  min_dot_size = 2,
  legend_width = 0.25,
  legend_height = 0.5,
  base_width_per_x = 0.5,
  base_height_per_y = 0.3,
  reverse_ordering = FALSE,
  cluster_by_row = TRUE,
  cluster_by_column = TRUE,
  show_legend = TRUE,
  cat_a = NULL,
  cat_b = NULL,
  cat_c = NULL,
  cat_c_colors = NULL,
  cat_b_order = NULL,
  base_width_per_cat_a = NULL,
  base_height_per_cat_b = NULL
)
}
\arguments{
\item{data}{A data frame containing the categorical and group variables for plotting.}

\item{x}{A string representing the column name in \code{data} for the first categorical variable.}

\item{y}{A string representing the column name in \code{data} for the second categorical variable.}

\item{z}{A string representing the column name in \code{data} for the third categorical variable.}

\item{group}{A string representing the column name in \code{data} for the grouping variable.}

\item{group_alpha}{A numeric value for the transparency level of the group rectangles. Default is \code{0.5}.}

\item{title}{An optional string for the plot title. Defaults to \code{NULL}.}

\item{z_colors}{A named vector of colors for \code{z} categories or a string to chose a colorbrewer palette. Defaults to \code{NULL} using the first suitable colorbrewer palette to use.}

\item{group_colors}{A named vector of colors for the group variableor a string to chose a colorbrewer palette. Defaults to \code{NULL} using the first suitable colorbrewer palette to use.}

\item{custom_theme}{A ggplot2 theme for customizing the plot's appearance. Defaults to \code{theme_minimal()}.}

\item{max_dot_size}{Maximal dot size for the plot to scale the dot sizes.}

\item{min_dot_size}{Minimal dot size for the plot to scale the dot sizes.}

\item{legend_width}{Relative width of your legend. Default is 0.25.}

\item{legend_height}{Relative width of your legend. Default is 0.5.}

\item{base_width_per_x}{Used for dynamically scaling the width. Default is 0.5.}

\item{base_height_per_y}{Used for dynamically scaling the height. Default is 0.3.}

\item{reverse_ordering}{Should the cluster ordering be reversed?. Default is FALSE.}

\item{cluster_by_row}{Cluster rows, defaults to TRUE}

\item{cluster_by_column}{Cluster columns, defaults to TRUE}

\item{show_legend}{Do you want to show the legend? Default is TRUE}

\item{cat_a}{Deprecated. Use \code{x} instead.}

\item{cat_b}{Deprecated. Use \code{y} instead.}

\item{cat_c}{Deprecated. Use \code{z} instead.}

\item{cat_c_colors}{Deprecated. Use \code{z_colors} instead.}

\item{cat_b_order}{Deprecated. Use \code{cluster_by_row} instead. Will be removed in a future version.}

\item{base_width_per_cat_a}{Deprecated. Use \code{base_width_per_x} instead.}

\item{base_height_per_cat_b}{Deprecated. Use \code{base_height_per_y} instead.}
}
\value{
A ggplot object representing the dice plot.
}
\description{
This function generates a custom plot based on three categorical variables and a group variable. It adapts to the number of unique categories in \code{z} and allows customization of various plot aesthetics.
}
