% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution.R, R/new_distribution.R
\name{distribution}
\alias{distribution}
\alias{is_distribution}
\alias{is.distribution}
\title{Distribution Objects}
\usage{
distribution(..., .vtype = NULL, .name = NULL, .parameters = list())

is_distribution(object)

is.distribution(object)
}
\arguments{
\item{...}{Name-value pairs for defining the distribution.}

\item{.vtype}{The variable type, typically "discrete" or "continuous".
Can be any character vector of length 1, but is converted to
lowercase with \code{tolower()} for compliance with known types.}

\item{.name}{A name to give to the distribution.
Can be any character vector of length 1.}

\item{.parameters}{A named list with one entry per distribution parameter,
each of which can be any data type. In this version of distionary,
these parameters are only stored for the benefit of the user to know
what distribution they are working with; the code never looks at these
parameters to inform its calculations. This is anticipated to change in
a future version of distionary.}

\item{object}{Object to be tested}
}
\value{
A distribution object.
}
\description{
Distribution Objects
}
\details{
Currently, the CDF (\code{cdf}) is required to be specified, along with the PMF
(\code{pmf}) for discrete distributions and density (\code{density}) for continuous
distributions. Otherwise, the full extent of distribution properties will
not be accessible.

A distributional representation is a function that fully describes the
distribution. Besides \code{cdf}, \code{density}, and \code{pmf}, other options
understood by \code{distionary} include:
\itemize{
\item \code{survival}: the survival function, or one minus the cdf.
\item \code{hazard}: the hazard function, for continuous variables only.
\item \code{chf}: the cumulative hazard function, for continuous variables only.
\item \code{quantile}: the quantile function, or left-inverse of the cdf.
\item \code{realise} or \code{realize}: a function that takes an integer and generates
a vector of that many random draws from the distribution.
\item \code{odds}: for discrete variables, the probability odds function
(pmf / (1 - pmf))
\item \code{return}: the quantiles associated with the provided return periods,
where events are exceedances.
}

All functions should be vectorized.

Other properties that are understood by \code{distionary} include:
\itemize{
\item \code{mean}, \code{stdev}, \code{variance}, \code{skewness}, \code{median} are self-explanatory.
\item \code{kurtosis_exc} and \code{kurtosis} are the distribution's excess
kurtosis and regular kurtosis.
\item \code{range}: A vector of the minimum and maximum value of a distribution's
support.
}
}
\examples{
linear <- distribution(
  density = function(x) {
    d <- 2 * (1 - x)
    d[x < 0 | x > 1] <- 0
    d
  },
  cdf = function(x) {
    p <- 2 * x * (1 - x / 2)
    p[x < 0] <- 0
    p[x > 1] <- 1
    p
  },
  .vtype = "continuous",
  .name = "My Linear",
  .parameters = list(could = "include", anything = data.frame(x = 1:10))
)

# Inspect
linear

# Plot
plot(linear)
}
\concept{Distribution Construction}
