% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\name{[.dist}
\alias{[.dist}
\title{Distance Matrix Subset Operator}
\usage{
\method{[}{dist}(x, i, j, drop = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{\link[stats:dist]{stats::dist}}.}

\item{i}{An integer vector of row indices. Values must be either all positive
in which case they indicate the rows to select, or all negative in which
case they indicate the rows to omit.}

\item{j}{An integer vector of column indices. Values must be either all
positive in which case they indicate the columns to select, or all negative
in which case they indicate the columns to omit.}

\item{drop}{A logical value indicating whether the result should be coerced
to a vector or matrix if possible.}

\item{...}{Additional arguments passed to \verb{[.dist}.}
}
\value{
A numeric matrix storing the pairwise distances between the requested
observations.
}
\description{
Subset operator for the distance matrix stored as an object of
class \code{\link[stats:dist]{stats::dist}}.
}
\examples{
D <- stats::dist(iris[, 1:4])
D[2:3, 7:12]
}
