% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ent_sp_simpson.R
\name{ent_sp_simpson}
\alias{ent_sp_simpson}
\alias{ent_sp_simpsonEnvelope}
\title{Spatially Explicit Simpson's Entropy}
\usage{
ent_sp_simpson(
  X,
  r = NULL,
  correction = c("isotropic", "translate", "none"),
  check_arguments = TRUE
)

ent_sp_simpsonEnvelope(
  X,
  r = NULL,
  n_simulations = 100,
  alpha = 0.05,
  correction = c("isotropic", "translate", "none"),
  h0 = c("RandomPosition", "RandomLabeling"),
  global = FALSE,
  check_arguments = TRUE
)
}
\arguments{
\item{X}{a spatialized community
(A \link[dbmss:wmppp]{dbmss::wmppp} object with \code{PointType} values as species names.)}

\item{r}{a vector of distances.}

\item{correction}{the edge-effect correction to apply when estimating
the number of neighbors or the \emph{K} function with \link[spatstat.explore:Kest]{spatstat.explore::Kest}.
Default is "isotropic".}

\item{check_arguments}{if \code{TRUE}, the function arguments are verified.
Should be set to \code{FALSE} to save time when the arguments have been checked elsewhere.}

\item{n_simulations}{the number of simulations used to estimate the confidence envelope.}

\item{alpha}{the risk level, 5\% by default.}

\item{h0}{A string describing the null hypothesis to simulate.
The null hypothesis may be "RandomPosition": points are drawn in a Poisson process (default)
or "RandomLabeling": randomizes point types, keeping locations unchanged.}

\item{global}{if \code{TRUE}, a global envelope sensu \insertCite{Duranton2005}{divent} is calculated.}
}
\value{
\code{ent_sp_simpson} returns an object of class \code{fv},
see \link[spatstat.explore:fv.object]{spatstat.explore::fv.object}.
There are methods to print and plot this class.
It contains the value of the spatially explicit Simpson's entropy
for each distance in \code{r}.

\code{ent_sp_simpsonEnvelope} returns an envelope object \link[spatstat.explore:envelope]{spatstat.explore::envelope}.
There are methods to print and plot this class.
It contains the observed value of the function,
its average simulated value and the confidence envelope.
}
\description{
Simpson's entropy of the neighborhood of individuals,
up to a distance \insertCite{Shimatani2001}{divent}.
}
\examples{
# Generate a random community
X <- rspcommunity(1, size = 1000, species_number = 3)
# Calculate the entropy and plot it
autoplot(ent_sp_simpson(X))

# Generate a random community
X <- rspcommunity(1, size = 100, species_number = 3)
# Calculate the entropy and plot it
autoplot(ent_sp_simpsonEnvelope(X, n_simulations = 10))

}
\references{
\insertAllCited{}
}
