% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inv_simpson.R
\name{ds_inv_simpson}
\alias{ds_inv_simpson}
\alias{inv_simpson}
\title{Compute Simpson Index}
\usage{
ds_inv_simpson(.data, .cols, .name)

inv_simpson(..., .data = dplyr::across(everything()))
}
\arguments{
\item{.data}{\link[tibble:tibble-package]{tibble}}

\item{.cols}{\href{https://tidyselect.r-lib.org/reference/language.html}{\code{tidy-select}}
Columns to compute the measure with.}

\item{.name}{name for column with Simpson Index Leave missing to return a vector.}

\item{...}{arguments to forward to ds_inv_simpson from inv_simpson}
}
\value{
a \link[tibble:tibble-package]{tibble} or numeric vector if .name missing
}
\description{
Compute Simpson Index
}
\examples{
data('de_county')
ds_inv_simpson(de_county, starts_with('pop_'))
ds_inv_simpson(de_county, starts_with('pop_'), 'blau')
}
\concept{div}
