% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_dlim.R
\name{sim_dlim}
\alias{sim_dlim}
\title{Fit DLIM for simulation}
\usage{
sim_dlim(
  data,
  df_m,
  df_l,
  penalize = TRUE,
  pen_fn = "ps",
  mod_args = NULL,
  lag_args = NULL,
  fit_dlm = FALSE,
  model_type = "nonlinear",
  ...
)
}
\arguments{
\item{data}{output from \code{sim_data}}

\item{df_m}{degrees of freedom for modifiers}

\item{df_l}{degrees of freedom for lags}

\item{penalize}{True to penalize model}

\item{pen_fn}{if penalizing, can specify "ps" for penalized B-splines or "cr" for cubic regression splines with penalties on second derivatives}

\item{mod_args}{a list of additional arguments for the spline function (must be named by argument)}

\item{lag_args}{a list of additional arguments for the spline function (must be named by argument)}

\item{fit_dlm}{True to additionally fit dlm for comparison}

\item{model_type}{"linear" for a DLIM with linear interaction (linear modifier basis), "quadratic" for a DLIM with quadratic interaction (quadratic modifier basis), "nonlinear" for a DLIM with non-linear interaction (spline modifier basis)}

\item{...}{arguments to pass to model fitting function}
}
\value{
This function returns an object of class "\code{sim_dlim}"
\item{cb}{DLIM cross-basis (class "\code{cross-basis}")}
\item{fit}{DLIM model fit (class "\code{lm}", "\code{glm}", "\code{gam}")}
\item{cb_dlm}{DLM cross-basis (class "\code{crossbasis}")}
\item{model_dlm}{DLM model fit (class "\code{lm}", "\code{glm}", "\code{gam}")}
\item{true_betas}{true linear effect of the exposure on the response for each individual and time point (class "\code{matrix}")}
\item{modifiers}{\code{modifiers} from \code{numeric}}
\item{data}{\code{data} (class "\code{list}")}
}
\description{
Fit DLIM for simulation
}
\seealso{
\link[dlim]{dlim}

\link[dlim]{sim_data}

Type \code{vignette('dlimOverview')} for a detailed description.
}
