% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spell_text.R
\name{spell_text}
\alias{spell_text}
\title{Retrieve Full Spell Description Text by Spell Name}
\usage{
spell_text(name = NULL, ver = "2014")
}
\arguments{
\item{name}{(character) exact spell name(s) for which to gather description information}

\item{ver}{(character) which version of fifth edition to use ("2014" or "2024"). Note that only 2014 is supported and entering "2024" will print a warning to that effect}
}
\value{
(dataframe) 11 columns of spell information with one row per spell specified by the user. Returns 12 columns if the spell is a damage-dealing cantrip that deals increased damage as player level increases or if spell can be cast with a higher level spell slot (i.e., "upcast") for an increased effect.
}
\description{
Accepts user-provided fifth edition Dungeons & Dragons spell name(s) and returns the full set of spell information (for the 2014 version) and the complete description text. Unlike `dndR::spell_list`, this function requires an exact match between the user-provided spell name(s) and how they appear in the main spell data object. The argument in this function is not sensitive. This function's output differs from `dndR::spell_list` only in that it returns the additional spell description text.
}
\examples{
dndR::spell_text(name = "chill touch")

}
