# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Split-normal distribution
#'
#' Density distribution function, quantile function and random generation function for
#' the split normal distribution.
#'
#' The random ' variable y follows a split-normal distribution, y~N(\eqn{\mu}, '
#' \eqn{\sigma}, \eqn{\lambda}), which has density: \deqn{1/(1+\lambda)\sigma ' \sqrt(2/\pi)
#' exp{-(y-\mu)*2/2\sigma^2}, if y<=\mu} ' \deqn{1/(1+\lambda)\sigma \sqrt(2/\pi)
#' exp{-(y-\mu)*2/2\sigma^2 \lambda^2}, ' if y>\mu} where \eqn{\sigma>0} and
#' \eqn{\lambda>0}. The Split-normal ' distribution reduce to normal distribution when
#' \eqn{\lambda=1}.
#'
#' @name splitn
#' @param x vector of quantiles.
#' @param mu vector of location parameter. (The mode of the density)
#' @param sigma vector of standard deviations.
#' @param lmd vector of skewness parameters (>0). If is 1, reduced to
#' symmetric normal distribution.
#' @param p vector of probability.
#' @param q vector of quantiles.
#' @param n number of observations. If length(n) > 1, the length is taken to be the number required.
#' @param logarithm logical; if TRUE, probabilities p are given as log(p).
#' @return \code{dsplitn} gives the density; \code{psplitn} gives the percentile;
#' \code{qsplitn} gives the quantile; and \code{rsplitn} gives the random
#' variables. Invalid arguments will result in return value NaN, with a warning.
#'
#' The numerical arguments other than n are recycled to the length of the
#' result. Only the first elements of the logical arguments are used.
#'
#' @author Feng Li, Jiayue Zeng
#' @seealso \code{\link{splitn_mean}()},
#' \code{\link{splitn_var}()},\code{\link{splitn_skewness}()} and
#' \code{\link{splitn_kurtosis}()} for numerical characteristics of the
#' split-normal distribution.
#'
#' @references
#' Villani, M., & Larsson, R. (2006) The Multivariate Split Normal
#' Distribution and Asymmetric Principal Components Analysis. Sveriges
#' Riksbank Working Paper Series, No. 175.
#'
#' @keywords distribution asymmetric normal
#' @examples
#'
#' n <- 3
#' mu <- c(0,1,2)
#' sigma <- c(1,2,3)
#' lmd <- c(1,2,3)
#'
#' q0 <- rsplitn(n, mu, sigma, lmd)
#' d0 <- dsplitn(q0, mu, sigma, lmd, logarithm = FALSE)
#' p0 <- psplitn(q0, mu, sigma, lmd)
#' q1 <- qsplitn(p0,mu, sigma, lmd)
#' all.equal(q0, q1)
#' @export
dsplitn <- function(x, mu, sigma, lmd, logarithm) {
    .Call('_dng_dsplitn', PACKAGE = 'dng', x, mu, sigma, lmd, logarithm)
}

#' Split-t distribution
#'
#' Density, distribution function, quantile function and random generation for the normal
#' distribution for the split student-t distribution.
#'
#' The random variable y follows a split-t distribution with \eqn{\nu}>0
#' degrees of freedom, y~t(\eqn{\mu}, \eqn{\phi}, \eqn{\lambda}, \eqn{\nu}),
#' if its density function is of the form
#'
#' \deqn{C K(\mu, \phi, \nu,)I(y\leq\mu) + C K(\mu, \lambda \phi,
#' \nu)I(y>\mu), } where, \deqn{K(\mu, \phi, \nu,) =[\nu/(\nu+(y-\mu)^2 /\phi
#' ^2)]^{(\nu+1)/2} } is the kernel of a student \eqn{t} density with variance
#' \eqn{\phi ^2\nu/(\nu-2)} and \deqn{c = 2[(1+\lambda)\phi (\sqrt \nu)
#' Beta(\nu/2,1/2)]^{-1} }is the normalization constant.
#'
#' @name splitt
#'
#' @param x vector of quantiles.
#' @param mu vector of location parameter. (The mode of the density)
#' @param df degrees of freedom (> 0, can be non-integer). df = Inf is also allowed.
#' @param phi vector of scale parameters (>0).
#' @param lmd vector of skewness parameters (>0). If is 1, reduced to the
#' symmetric student t distribution.
#' @param p vector of probability.
#' @param q vector of quantiles.
#' @param n number of observations. If length(n) > 1, the length is taken to be the number required.
#' @param logarithm logical; if TRUE, probabilities p are given as log(p).
#' @return \code{dsplitt} gives the density; \code{psplitt} gives the percentile;
#' \code{qsplitt} gives the quantile; and \code{rsplitt} gives the random
#' variables. Invalid arguments will result in return value NaN, with a warning.
#'
#' The numerical arguments other than n are recycled to the length of the
#' result. Only the first elements of the logical arguments are used.
#'
#' @author Feng Li, Jiayue Zeng
#' @seealso \code{\link{splitt_mean}()},
#' \code{\link{splitt_var}()},\code{\link{splitt_skewness}()} and
#' \code{\link{splitt_kurtosis}()} for numerical characteristics of the
#' Split-t distribution.
#'
#' @references
#' Li, F., Villani, M., & Kohn, R. (2010). Flexible modeling of
#' conditional distributions using smooth mixtures of asymmetric student t
#' densities. Journal of Statistical Planning & Inference, 140(12), 3638-3654.
#' @keywords distribution asymmetric student-t
#'
#' @examples
#'
#' n <- 3
#' mu <- c(0,1,2)
#' df <- rep(10,3)
#' phi <- c(0.5,1,2)
#' lmd <- c(1,2,3)
#'
#' q0 <- rsplitt(n, mu, df, phi, lmd)
#' d0 <- dsplitt(q0, mu, df, phi, lmd, logarithm = FALSE)
#' p0 <- psplitt(q0, mu, df, phi, lmd)
#' q1 <- qsplitt(p0,mu, df, phi, lmd)
#' all.equal(q0, q1)
#'
#' @export
dsplitt <- function(x, mu, df, phi, lmd, logarithm) {
    .Call('_dng_dsplitt', PACKAGE = 'dng', x, mu, df, phi, lmd, logarithm)
}

#' @describeIn splitn Percentile for the split-normal distribution.
#' @export
psplitn <- function(q, mu, sigma, lmd) {
    .Call('_dng_psplitn', PACKAGE = 'dng', q, mu, sigma, lmd)
}

#' @describeIn splitt Percentile for the split-t distribution.
#' @export
psplitt <- function(q, mu, df, phi, lmd) {
    .Call('_dng_psplitt', PACKAGE = 'dng', q, mu, df, phi, lmd)
}

#' @describeIn splitn Quantile for the split-normal distribution.
#' @export
qsplitn <- function(p, mu, sigma, lmd) {
    .Call('_dng_qsplitn', PACKAGE = 'dng', p, mu, sigma, lmd)
}

#' @describeIn splitt Quantile for the split-t distribution.
#' @export
qsplitt <- function(p, mu, df, phi, lmd) {
    .Call('_dng_qsplitt', PACKAGE = 'dng', p, mu, df, phi, lmd)
}

#' @describeIn splitn Randon variables from the split-normal distribution.
#' @export
rsplitn <- function(n, mu, sigma, lmd) {
    .Call('_dng_rsplitn', PACKAGE = 'dng', n, mu, sigma, lmd)
}

#' @describeIn splitt Randon variables from the split-t distribution.
#' @export
rsplitt <- function(n, mu, df, phi, lmd) {
    .Call('_dng_rsplitt', PACKAGE = 'dng', n, mu, df, phi, lmd)
}

#' @describeIn splitn_moments Kurtosis for the split-normal distribution.
#' @export
splitn_kurtosis <- function(lmd) {
    .Call('_dng_splitn_kurtosis', PACKAGE = 'dng', lmd)
}

#' Moments of the split normal distribution
#'
#' Computing the mean, variance, skewness and kurtosis for the split-normal
#' distribution.
#'
#'
#' @name splitn_moments
#' @param mu vector of location parameter. (The mode of the density)
#' @param sigma vector of standard deviations.
#' @param lmd vector of skewness parameters (>0). If is 1, reduce to normal
#' distribution.
#' @return \code{splitn_mean} gives the mean.  \code{splitn_var} gives the
#' variance.  \code{splitn_skewness} gives the skewness.
#' \code{splitn_kurtosis} gives the kurtosis.  (\code{splitn_mean},
#' \code{splitn_var},\code{splitn_skeness} and \code{splitn_kurtosis} are all
#' vectors.
#'
#' @author Feng Li, Jiayue Zeng
#'
#' @seealso \code{\link{psplitn}()} \code{\link{dsplitn}()} \code{\link{qsplitn}()} and
#' \code{\link{rsplitn}()} for the split-normal distribution.
#'
#' @references
#' Villani, M., & Larsson, R. (2006) The Multivariate Split Normal
#' Distribution and Asymmetric Principal Components Analysis. Sveriges
#' Riksbank Working Paper Series, No. 175.
#'
#' @keywords distribution asymmetric normal
#' @examples
#'
#' mu <- c(0,1,2)
#' sigma <- c(0.5,1,2)
#' lmd <- c(1,2,3)
#'
#' mean0 <- splitn_mean(mu, sigma, lmd)
#' var0 <- splitn_var(sigma, lmd)
#' skewness0 <- splitn_skewness(sigma, lmd)
#' kurtosis0 <- splitn_kurtosis(lmd)
#' @export
splitn_mean <- function(mu, sigma, lmd) {
    .Call('_dng_splitn_mean', PACKAGE = 'dng', mu, sigma, lmd)
}

#' @describeIn splitn_moments Skewness for the split-normal distribution.
#' @export
splitn_skewness <- function(sigma, lmd) {
    .Call('_dng_splitn_skewness', PACKAGE = 'dng', sigma, lmd)
}

#' @describeIn splitn_moments Variance for the split-normal distribution.
#' @export
splitn_var <- function(sigma, lmd) {
    .Call('_dng_splitn_var', PACKAGE = 'dng', sigma, lmd)
}

#' @describeIn splitt_moments Kurtosis for the split-t distribution.
#' @export
splitt_kurtosis <- function(df, phi, lmd) {
    .Call('_dng_splitt_kurtosis', PACKAGE = 'dng', df, phi, lmd)
}

#' Moments of the split-t distribution
#'
#' Computing the mean, variance, skewness and kurtosis for the split student-t
#' distribution.
#'
#'
#' @name splitt_moments
#' @param mu vector of location parameter. (The mode of the density)
#' @param df degrees of freedom (> 0, can be non-integer). df = Inf is allowed.
#' @param phi vector of scale parameters (> 0).
#' @param lmd vector of skewness parameters (> 0). If is 1, reduced to
#' symmetric student t distribution.
#' @return \code{splitt_mean} gives the mean. \code{splitt_var} gives the
#' variance. \code{splitt_skewness} gives the skewness. \code{splitt_kurtosis}
#' gives the kurtosis. (\code{splitt_mean},
#' \code{splitt_var},\code{splitt_skeness} and \code{splitt_kurtosis} are all
#' vectors.)
#'
#' Invalid arguments will result in return value NaN, with a warning.
#' @author Feng Li, Jiayue Zeng
#' @seealso \code{\link{dsplitt}()}, \code{\link{psplitt}()},
#' \code{\link{qsplitt}()} and \code{\link{rsplitt}()} for the split-t
#' distribution.
#'
#' @references
#' Li, F., Villani, M., & Kohn, R. (2010). Flexible modeling of
#' conditional distributions using smooth mixtures of asymmetric student t
#' densities. Journal of Statistical Planning & Inference, 140(12), 3638-3654.
#' @keywords distribution asymmetric student-t
#' @examples
#'
#' mu <- c(0,1,2)
#' df <- rep(10,3)
#' phi <- c(0.5,1,2)
#' lmd <- c(1,2,3)
#'
#' mean0 <- splitt_mean(mu, df, phi, lmd)
#' var0 <- splitt_var(df, phi, lmd)
#' skewness0 <- splitt_skewness(df, phi, lmd)
#' kurtosis0 <- splitt_kurtosis(df, phi, lmd)
#' @export
splitt_mean <- function(mu, df, phi, lmd) {
    .Call('_dng_splitt_mean', PACKAGE = 'dng', mu, df, phi, lmd)
}

#' @describeIn splitt_moments Skewness for the split-t distribution.
#' @export
splitt_skewness <- function(df, phi, lmd) {
    .Call('_dng_splitt_skewness', PACKAGE = 'dng', df, phi, lmd)
}

#' @describeIn splitt_moments Variance for the split-t distribution.
#' @export
splitt_var <- function(df, phi, lmd) {
    .Call('_dng_splitt_var', PACKAGE = 'dng', df, phi, lmd)
}

