% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docs.R
\name{expect-tag}
\alias{expect-tag}
\alias{@expect}
\title{Create an expectation}
\description{
\verb{@expect} creates an expectation for your example code.
}
\details{
Use \verb{@expect} to create a \link[testthat:testthat-package]{testthat} expectation.

\if{html}{\out{<div class="sourceCode">}}\preformatted{#' @doctest
#'
#' @expect equals(4)
#' 2 + 2
#'
#' f <- function () warning("Watch out")
#' @expect warning()
#' f()
}\if{html}{\out{</div>}}

The next expression will be inserted as the first
argument to the \verb{expect_*} call.

Don't include the \code{expect_} prefix.

If you want to include the expression in a different
place or places, use a dot \code{.}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{@expect equals(., rev(.))
c("T", "E", "N", "E", "T")
}\if{html}{\out{</div>}}

The \verb{@expect} tag and code must fit on a single line.
}
\seealso{
Other expectations: 
\code{\link{expectRaw-tag}},
\code{\link{snap-tag}}
}
\concept{expectations}
