% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doremi.R
\name{analyze.1order}
\alias{analyze.1order}
\title{DOREMI first order analysis function}
\usage{
analyze.1order(
  data,
  id = NULL,
  input = NULL,
  time = NULL,
  signal,
  dermethod = "gold",
  derparam = 3,
  order = 1,
  verbose = FALSE
)
}
\arguments{
\item{data}{Is a data frame containing at least one column, that is the signal to be analyzed.}

\item{id}{Is a CHARACTER containing the NAME of the column of data containing the identifier of the individual.
If this parameter is not entered when calling the function, a single individual is assumed and a linear regression is done instead
of the linear mixed-effects regression.}

\item{input}{Is a CHARACTER or a VECTOR OF CHARACTERS containing the NAME(s) of data column(s) containing the EXCITATION vector(s).
If this parameter is not entered when calling the function,
the excitation is assumed to be unknown. In this case, the linear mixed-effect regression is still carried out but no coefficient is calculated
for the excitation term. The function then uses the parameters estimated by the regression to carry out an exponential fit of the signal
and build the estimated curve.
The function will consider as an excitation each column of data having a name contained in the input vector.
The function will return a coefficient for each one of the excitation variables included in the input vector.}

\item{time}{Is a CHARACTER containing the NAME of the column of data containing the time vector. If this parameter is not entered when calling the function,
it is assumed that time steps are of 1 unit and the time vector is generated internally in the function.}

\item{signal}{Is a CHARACTER containing the NAME of the column of the data frame containing the SIGNAL to be studied.}

\item{dermethod}{is the derivative estimation method. default is "gold".
The values are "gold","glla" and "fda", corresponding to the use of
\code{calculate.gold}, \code{calculate.glla} or \code{calculate.fda} to estimate the derivatives}

\item{derparam}{If dermethod "glla" or "gold" are chosen, it is the embedding number, a positive integer containing the number of points to be used for the calculation of the derivatives.
Default is 3. At least two points are needed for the calculation of the first derivative. If dermethod "fda" is chosen, this parameter is
spar, the parameter related to the smoothing parameter lambda used in the penalization function of the function \code{smooth.spline} to estimate the derivative via splines (Functional Data Analysis).
In this case, the value should be between 0 and 1, see \code{?smooth.spline}}

\item{order}{is the maximum order of the derivative estimated when using \code{calculate.gold} or \code{calculate.glla}.
Although only the first derivative is used here, using a higher order can enhance derivative estimation (see \doi{10.1080/00273171.2015.1123138}{Chow et al.(2016)})}

\item{verbose}{Is a boolean that displays status messages of the function when set to 1. Useful for debugging.}
}
\value{
Returns a summary of the fixed effect coefficients estimated by the linear regression
}
\description{
\code{analyze.1order}  estimates the coefficients of a first order differential equation of the form:
\deqn{\frac{dy}{dt}(t) + \gamma (y(t) - yeq) = \gamma k*u(t)}
using linear mixed-effect models.
Where y(t) is the individual's signal,\eqn{\gamma} the decay rate (and \eqn{\tau = 1/\gamma the decay time}),
\eqn{\frac{dy(t)}{dt}} is the derivative and u(t) is an external excitation perturbing the dynamics.
}
\details{
The analysis performs the following linear mixed-effects regression:
\deqn{ \dot{y_{ij}} \sim   (b_{0} +b_{0j}) + (b_{1}+b_{1j}) y_{ij}+ (b_{2}+b_{2j}) u_{ij} +e_{ij}}
with i accounting for the time and j for the different individuals. \eqn{e_{ij}} are the residuals,
\eqn{\dot{y_{ij}}} is the derivative calculated on embedding points and
\eqn{y_{ij}} and \eqn{u_{ij}} are the signal and the excitation averaged on embedding points.
The fixed effect coefficients estimated from the regression are:
\itemize{
  \item gamma: \eqn{b_1} (\eqn{\gamma} from the differential equation)
  \item kgamma: \eqn{b_2} (\eqn{k\gamma} from the differential equation)
  \item yeqgamma: \eqn{b_0} (\eqn{\gamma y_{eq}} from the differential equation)
}
The coefficients derived to characterize the signal are calculated as follows:
\itemize{
  \item the decay time, tau:  \eqn{\tau =  \frac{1}{  b_1 } = \frac{1}{\gamma}}
  \item the gain, k: \eqn{\gamma = \frac{b_2}{b_1}}. It is the proportionality between the stationary increase of the signal and
  the excitation increase that caused it.
  \item the equilibrium value, yeq: \eqn{yeq = \frac{b_0}{b_1}}. It is the stationary value reached in the absence of excitation.
}
The estimation is performed using the function lmer if there are several individuals or lm if there is only one.
With the above estimated parameters, the estimated signal can be reconstructed for
each individual by using the generate.1order function of this package (based on deSolve's ode function).
The function returns five objects:
\enumerate{
 \item data- A data.frame including the input data, the intermediate calculations used to prepare the variables for
  the fit and the estimated trajectories for each individual.
\enumerate{
    \item signal_rollmean - calculation of the moving average of the signal over embedding points.

    \item signal_derivate1 - calculation of the first derivative of the signal with the gold, glla or fda methods in embedding points.

    \item time_derivate - calculation of the moving average of the time vector over embedding points.

    \item input_rollmean - calculation of the moving average of the excitation vector over embedding points.

    \item estimated - the estimated signal calculated using generate.1order with the excitation provided as input and the estimated decay time,
    gain and equilibrium value obtained from the regression. The initial condition y0 and t0 are the first value of the moving averaged
    signal (signal_rollmean) and time (time_derivate)
    }
 \item resultmean - A data.frame including the fixed effects of the coefficients estimated from the regression gamma, yeqgamma and the kgamma for each excitation considered,
 with their associated standard error gamma_stde, yeqgamma_stde and kgamma_stde,
 together with the derived coefficient tau (the decay time), yeq (the equilibrium value) and k (the gain)
 \item resultid - A data.frame including, for each individual listed by id number,  gamma, yeqgamma and the kgamma, together with the decay time tau,
 the gain k and the equilibrium value yeq
 \item regression - A list containing the summary of the linear mixed-effects regression.

 As seen in the Description section, the print method by default prints only the resultmean element. Each one of the other objects
 can be accessed by indicating $ and their name after the result, for instance, for a DOREMI object called "result", it is possible
 to access the regression summary by typing result$regression.
 \item embedding - contains the embedding number used to generate the results (same as function input argument)
 \item spar - contains the smoothing parameter used for the estimation of the derivatives using splines (method "fda")
}

SImulation presenting the statistical propoerties of the ethod can be found in \doi{10.1080/00273171.2020.1754155}(Mongin et al. (2020))
Example of application of this function can be found in:
\itemize{
    \item \doi{10.1088/1361-6579/abbb6e}
    \item \doi{10.1109/ESGCO49734.2020.9158156}
    \item \doi{10.1080/00273171.2020.1754155}
    \item \doi{10.1038/s41598-020-69218-1}
}
}
\examples{
myresult <- analyze.1order(data = cardio,
                  id = "id",
                  input = "load",
                  time = "time",
                  signal = "hr",
                  dermethod ="gold",
                  derparam = 5)
}
\seealso{
\code{\link{calculate.gold}, \link{calculate.glla}, \link{calculate.fda}} to compute the derivatives, for details on embedding/spar.
and \code{\link{generate.1order}} the function to generate the solution of the first order differential equation
}
\keyword{analysis}
\keyword{exponential}
\keyword{first-order}
