% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/additional.R
\name{waldtest}
\alias{waldtest}
\alias{print.waldtest}
\title{Wald Test for Model Coefficients}
\usage{
waldtest(Sigma, b, Terms = NULL, L = NULL, H0 = NULL)

\method{print}{waldtest}(x, digits = 2, ...)
}
\arguments{
\item{Sigma}{a var-cov matrix, usually extracted from one of the fitting functions.}

\item{b}{a vector of coefficients with var-cov matrix \code{Sigma}. These coefficients are usually extracted 
from one of the fitting functions available in \code{R}.}

\item{Terms}{an optional integer vector specifying which coefficients should be jointly tested, using a Wald 
chi-squared or F test. Its elements correspond to the columns or rows of the var-cov matrix given in \code{Sigma}. 
Default is \code{NULL}.}

\item{L}{an optional matrix conformable to \code{b}, such as its product with \code{b} gives 
the linear combinations of the coefficients to be tested. Default is \code{NULL}.}

\item{H0}{a numeric vector giving the null hypothesis for the test. It must be as long as \code{Terms} or must 
have the same number of columns as \code{L}. Default to 0 for all the coefficients to be tested.}

\item{x}{Object of class "waldtest".}

\item{digits}{number of decimal places for displaying test results. Default to 2.}

\item{\dots}{further arguments passed to or from other methods.}
}
\value{
An object of class \code{waldtest}, printed with \code{print.waldtest}.
}
\description{
Computes a Wald chi-squared test for 1 or more coefficients, given their variance-covariance matrix.
}
\details{
The \code{waldtest} and the method \code{print.waldtest} are taken from the \code{aod} package and 
simplified for ease of use.
}
\examples{
## Load data and run the model
data("alcohol_cvd")
model <- dosresmeta(formula = logrr ~ dose + I(dose^2), type = type, id = id,
                    se = se, cases = cases, n = n, data = alcohol_cvd) 
                    
## Test for significance of the overall dose-response association
waldtest(b = coef(model), Sigma = vcov(model), Terms = 1:nrow(vcov(model)))

}
\seealso{
\code{aod}, \code{\link{summary.dosresmeta}}
}
\author{
Alessio Crippa, \email{alessio.crippa@ki.se}
}
