% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpseg.R
\name{movie}
\alias{movie}
\title{Visualizes the \code{\link{dpseg}} segmentation recursion as a movie.}
\usage{
movie(dpseg, fix.ylim = TRUE, frames, delay = 0.1, repeat.last = 5,
  ylab = "scoring function", ylab2 = "y", xlab = "x", path,
  file.name = "dpseg_movie", format = "gif", res = 200, ...)
}
\arguments{
\item{dpseg}{result object of class \code{\link{dpseg}} returned by
function \code{\link{dpseg}}}

\item{fix.ylim}{fix the y-axis of the \code{score} function}

\item{frames}{x range to show as movie frames}

\item{delay}{delay between frames in seconds, between x11 plot
updates or as argument \code{-delay} to the system call to
Image Magick's \code{convert}}

\item{repeat.last}{repeat list frame this many times}

\item{ylab}{left y-axis label, for the scoring funtion}

\item{ylab2}{right y-axis label, for the original data}

\item{xlab}{x-axis label}

\item{path}{path where both temporary jpeg files and the final
movie file will be generated. If not specified the indidividual
frames will be plotted to the active plot device.}

\item{file.name}{name of the generated video file
<path>/<file.name>.<format>}

\item{format}{format of the video, all outputs that image magick's
convert can generate, e.g. "mpg" or "gif"}

\item{res}{resolution of the generated movie (pixels per inch)}

\item{...}{arguments passed to default \code{\link{plot}} function}
}
\description{
Generates a movie of the calculation steps \eqn{j=1,\dots,n} while
looping through the recursion \eqn{S_j}. Plots are sent to the
active plot device or, if \code{path} is specified, to a video file
\code{<path>/<file.name>.<format>} via a system call to Image
Magick's \code{convert}.
Saving to a file likely only works on Linux systems with Image
Magick installed and \code{convert} available in the \code{$PATH}
environment variable. \code{format} are formats available for
\code{convert}, eg. \code{format="gif"} or \code{format="mpeg"}.
See the \code{vignette("dpseg")} for details on the plotted data.
}
\examples{

## NOTE: requires that dpseg is run with store.matrix=TRUE
segs <- dpseg(x=oddata$Time, y=log(oddata$A3), minl=5, P=0.0001, store.matrix=TRUE)

## View the algorithm in action:
movie(segs, delay=0)

## NOTE: if Image Magick's convert is installed you can set the path
## option to save the movie as <path>/<file.name>.<format>, where format
## can be "gif", "mpeg" or else, depending on the Image Magick installation.
}
